/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reatomizer.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public final class ItemStackNbtUtil {
    private ItemStackNbtUtil() {
    }

    public static Object unwrapOptionalObject(Object possibleOptional) {
        if (possibleOptional == null) {
            return null;
        }
        if (possibleOptional instanceof Optional) {
            Optional opt = (Optional)possibleOptional;
            return opt.orElse(null);
        }
        return possibleOptional;
    }

    public static class_2487 safeGetCompound(Object tagLike, String key) {
        if (!(tagLike instanceof class_2487) || key == null) {
            return null;
        }
        class_2487 t = (class_2487)tagLike;
        try {
            Optional opt = t.method_10562(key);
            return opt == null ? null : (class_2487)opt.orElse(null);
        }
        catch (Throwable ignored) {
            try {
                Optional opt2 = t.method_10562(key);
                return opt2 == null ? null : (class_2487)opt2.orElse(null);
            }
            catch (Throwable ignored2) {
                return null;
            }
        }
    }

    public static int safeGetInt(Object tagLike, String key) {
        if (!(tagLike instanceof class_2487) || key == null) {
            return 0;
        }
        class_2487 t = (class_2487)tagLike;
        try {
            Optional opt = t.method_10550(key);
            return opt == null ? 0 : opt.orElse(0);
        }
        catch (Throwable ignored) {
            try {
                Optional opt2 = t.method_10550(key);
                return opt2 == null ? 0 : opt2.orElse(0);
            }
            catch (Throwable ignored2) {
                return 0;
            }
        }
    }

    public static long safeGetLong(Object tagLike, String key) {
        if (!(tagLike instanceof class_2487) || key == null) {
            return 0L;
        }
        class_2487 t = (class_2487)tagLike;
        try {
            Optional opt = t.method_10537(key);
            return opt == null ? 0L : opt.orElse(0L);
        }
        catch (Throwable ignored) {
            try {
                Optional opt2 = t.method_10537(key);
                return opt2 == null ? 0L : opt2.orElse(0L);
            }
            catch (Throwable ignored2) {
                return 0L;
            }
        }
    }

    public static String safeGetString(Object tagLike, String key) {
        if (!(tagLike instanceof class_2487) || key == null) {
            return "";
        }
        class_2487 t = (class_2487)tagLike;
        try {
            Optional opt = t.method_10558(key);
            return opt == null ? "" : opt.orElse("");
        }
        catch (Throwable ignored) {
            try {
                Optional opt2 = t.method_10558(key);
                return opt2 == null ? "" : opt2.orElse("");
            }
            catch (Throwable ignored2) {
                return "";
            }
        }
    }

    public static class_2499 safeGetCompoundList(Object tagLike, String key) {
        if (!(tagLike instanceof class_2487) || key == null) {
            return null;
        }
        class_2487 t = (class_2487)tagLike;
        try {
            Optional opt = t.method_10554(key);
            return opt == null ? null : (class_2499)opt.orElse(null);
        }
        catch (Throwable ignored) {
            try {
                Optional opt2 = t.method_10554(key);
                return opt2 == null ? null : (class_2499)opt2.orElse(null);
            }
            catch (Throwable ignored2) {
                return null;
            }
        }
    }

    public static class_2487 readTag(class_1799 stack) {
        if (stack == null) {
            return null;
        }
        try {
            class_9279 cd = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
            class_2487 tag = cd.method_57461();
            if (tag == null || tag.method_33133()) {
                return null;
            }
            return tag;
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public static class_2487 getOrCreateTag(class_1799 stack) {
        if (stack == null) {
            return new class_2487();
        }
        try {
            class_9279 cd = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
            class_2487 tag = cd.method_57461();
            if (tag == null) {
                tag = new class_2487();
            }
            stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
            try {
                Method setTag = class_1799.class.getMethod("setTag", class_2487.class);
                if (setTag != null) {
                    setTag.invoke((Object)stack, tag);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return tag;
        }
        catch (Throwable ignored) {
            return new class_2487();
        }
    }

    public static boolean writeTag(class_1799 stack, class_2487 tag) {
        if (stack == null || tag == null) {
            return false;
        }
        try {
            stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
            try {
                Method setTag = class_1799.class.getMethod("setTag", class_2487.class);
                if (setTag != null) {
                    setTag.invoke((Object)stack, tag);
                }
            }
            catch (Throwable setTag) {
                // empty catch block
            }
            return true;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public static class_2487 serializeItemStack(class_1799 stack) {
        class_2487 out;
        block13: {
            out = new class_2487();
            if (stack == null || stack.method_7960()) {
                return out;
            }
            try {
                class_1792 item = stack.method_7909();
                try {
                    class_2960 key = class_7923.field_41178.method_10221((Object)item);
                    out.method_10582("id", key == null ? item.toString() : key.toString());
                }
                catch (Throwable t) {
                    out.method_10582("id", item.toString());
                }
                out.method_10569("Count", stack.method_7947());
                try {
                    Method saveMethod = null;
                    for (Method m : class_1799.class.getMethods()) {
                        if (!m.getName().equals("save") || m.getParameterCount() != 1 || m.getParameterTypes()[0] != class_2487.class) continue;
                        saveMethod = m;
                        break;
                    }
                    if (saveMethod != null) {
                        class_2487 full = (class_2487)saveMethod.invoke((Object)stack, new class_2487());
                        if (full != null && !full.method_33133()) {
                            out.method_10566("FullStack", (class_2520)full);
                        }
                        break block13;
                    }
                    try {
                        class_2487 full;
                        Method getTag = class_1799.class.getMethod("getTag", new Class[0]);
                        Object maybe = getTag.invoke((Object)stack, new Object[0]);
                        if (maybe instanceof class_2487 && !(full = (class_2487)maybe).method_33133()) {
                            out.method_10566("FullStack", (class_2520)full);
                        }
                    }
                    catch (Throwable throwable) {
                    }
                }
                catch (Throwable throwable) {}
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return out;
    }

    public static class_1799 deserializeItemStack(class_2487 tag) {
        block48: {
            if (tag == null) {
                return class_1799.field_8037;
            }
            try {
                class_2487 full;
                if (tag == null || !tag.method_10545("FullStack") || (full = ItemStackNbtUtil.safeGetCompound(tag, "FullStack")) == null || full.method_33133()) break block48;
                try {
                    Method ofMethod = null;
                    for (Method m : class_1799.class.getMethods()) {
                        if (!m.getName().equals("of") || m.getParameterCount() != 1 || m.getParameterTypes()[0] != class_2487.class) continue;
                        ofMethod = m;
                        break;
                    }
                    if (ofMethod != null) {
                        Object recreated = ofMethod.invoke(null, full);
                        if (recreated instanceof class_1799) {
                            return (class_1799)recreated;
                        }
                    } else {
                        Constructor<?>[] ctors;
                        for (Constructor<?> c : ctors = class_1799.class.getConstructors()) {
                            Object obj;
                            Class<?>[] params = c.getParameterTypes();
                            if (params.length != 1 || params[0] != class_2487.class || !((obj = c.newInstance(full)) instanceof class_1799)) continue;
                            return (class_1799)obj;
                        }
                    }
                }
                catch (Throwable ofMethod) {
                }
            }
            catch (Throwable full) {
                // empty catch block
            }
        }
        Optional idOpt = tag.method_10558("id");
        String id = idOpt == null ? null : (String)idOpt.orElse(null);
        int cnt = 1;
        try {
            Optional cntOpt = tag.method_10550("Count");
            cnt = cntOpt == null ? 1 : cntOpt.orElse(1);
        }
        catch (Throwable cntOpt) {
            // empty catch block
        }
        try {
            if (cnt <= 1) {
                Optional cntOpt2 = tag.method_10550("count");
                cnt = cntOpt2 == null ? cnt : cntOpt2.orElse(cnt);
            }
        }
        catch (Throwable cntOpt2) {
            // empty catch block
        }
        if (id == null || id.isEmpty()) {
            return class_1799.field_8037;
        }
        String ns = "minecraft";
        String path = id;
        if (id.contains(":")) {
            int idx = id.indexOf(58);
            ns = id.substring(0, idx);
            path = id.substring(idx + 1);
        }
        try {
            class_2960 rl = class_2960.method_60655((String)ns, (String)path);
            Optional maybeItem = class_7923.field_41178.method_17966(rl);
            if (maybeItem != null && maybeItem.isPresent()) {
                class_1799 s;
                block50: {
                    block49: {
                        s = new class_1799((class_1935)maybeItem.get(), cnt);
                        try {
                            class_2487 full = ItemStackNbtUtil.safeGetCompound(tag, "FullStack");
                            if (full == null || full.method_33133()) break block49;
                            try {
                                Method setTag = null;
                                for (Method m : class_1799.class.getMethods()) {
                                    if (!m.getName().equals("setTag") || m.getParameterCount() != 1 || m.getParameterTypes()[0] != class_2487.class) continue;
                                    setTag = m;
                                    break;
                                }
                                if (setTag != null) {
                                    setTag.invoke((Object)s, full);
                                }
                            }
                            catch (Throwable setTag) {}
                        }
                        catch (Throwable full) {
                            // empty catch block
                        }
                    }
                    try {
                        class_2487 comps = ItemStackNbtUtil.safeGetCompound(tag, "components");
                        if (comps != null && !comps.method_33133()) {
                            try {
                                class_2487 inner = ItemStackNbtUtil.safeGetCompound(comps, "minecraft:custom_data");
                                if (inner != null && !inner.method_33133()) {
                                    ItemStackNbtUtil.writeTag(s, inner);
                                } else {
                                    ItemStackNbtUtil.writeTag(s, comps);
                                }
                                try {
                                    String customName = ItemStackNbtUtil.safeGetString(comps, "minecraft:custom_name");
                                    if (customName != null && !customName.isEmpty()) {
                                        try {
                                            s.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)customName));
                                        }
                                        catch (Throwable throwable) {}
                                    }
                                    break block50;
                                }
                                catch (Throwable customName) {
                                }
                            }
                            catch (Throwable inner) {}
                            break block50;
                        }
                        class_2487 direct = ItemStackNbtUtil.safeGetCompound(tag, "minecraft:custom_data");
                        if (direct != null && !direct.method_33133()) {
                            try {
                                ItemStackNbtUtil.writeTag(s, direct);
                            }
                            catch (Throwable customName) {
                                // empty catch block
                            }
                        }
                        try {
                            String customNameRoot = ItemStackNbtUtil.safeGetString(tag, "minecraft:custom_name");
                            if (customNameRoot == null || customNameRoot.isEmpty()) break block50;
                            try {
                                s.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)customNameRoot));
                            }
                            catch (Throwable throwable) {
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return s;
            }
            return class_1799.field_8037;
        }
        catch (Throwable t) {
            try {
                return class_1799.field_8037;
            }
            catch (Throwable ignored) {
                return class_1799.field_8037;
            }
        }
    }

    public static String getRawNbtString(class_1799 stack) {
        try {
            class_2487 t = ItemStackNbtUtil.readTag(stack);
            if (t == null) {
                return "";
            }
            return t.toString();
        }
        catch (Throwable ignored) {
            return "";
        }
    }

    public static int countEnchantments(class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return 0;
        }
        try {
            Optional rootListOpt;
            class_2487 tag = ItemStackNbtUtil.readTag(stack);
            if (tag == null) {
                return 0;
            }
            class_2487 inner = null;
            Optional innerOpt = tag.method_10562("tag");
            if (innerOpt != null) {
                inner = innerOpt.orElse(null);
            }
            class_2499 list = null;
            if (inner != null) {
                Optional lopt2;
                Optional lopt = inner.method_10554("Enchantments");
                if (lopt != null) {
                    list = lopt.orElse(null);
                }
                if (list == null && (lopt2 = inner.method_10554("ench")) != null) {
                    list = lopt2.orElse(null);
                }
            }
            if (list == null && (rootListOpt = tag.method_10554("Enchantments")) != null) {
                list = rootListOpt.orElse(null);
            }
            if (list == null) {
                return 0;
            }
            return list.size();
        }
        catch (Throwable ignored) {
            return 0;
        }
    }

    public static Map<String, Integer> getEnchantmentsMap(class_1799 stack) {
        HashMap<String, Integer> out = new HashMap<String, Integer>();
        if (stack == null || stack.method_7960()) {
            return out;
        }
        try {
            Optional rootListOpt;
            class_2487 tag = ItemStackNbtUtil.readTag(stack);
            if (tag == null) {
                return out;
            }
            class_2487 inner = null;
            Optional innerOpt = tag.method_10562("tag");
            if (innerOpt != null) {
                inner = innerOpt.orElse(null);
            }
            class_2499 list = null;
            if (inner != null) {
                Optional lopt2;
                Optional lopt = inner.method_10554("Enchantments");
                if (lopt != null) {
                    list = lopt.orElse(null);
                }
                if (list == null && (lopt2 = inner.method_10554("ench")) != null) {
                    list = lopt2.orElse(null);
                }
            }
            if (list == null && (rootListOpt = tag.method_10554("Enchantments")) != null) {
                list = rootListOpt.orElse(null);
            }
            if (list == null) {
                return out;
            }
            for (int i = 0; i < list.size(); ++i) {
                try {
                    int lvl;
                    class_2487 entry;
                    Optional entryOpt = list.method_10602(i);
                    class_2487 class_24872 = entry = entryOpt == null ? null : (class_2487)entryOpt.orElse(null);
                    if (entry == null) continue;
                    Optional idOpt = entry.method_10558("id");
                    String id = idOpt == null ? null : (String)idOpt.orElse(null);
                    Optional lvlOpt = entry.method_10550("lvl");
                    int n = lvl = lvlOpt == null ? 0 : lvlOpt.orElse(0);
                    if (id == null) continue;
                    out.put(id, lvl);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return out;
    }

    public static String getEnchantmentsTooltip(class_1799 stack) {
        Map<String, Integer> m = ItemStackNbtUtil.getEnchantmentsMap(stack);
        if (m == null || m.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, Integer> e : m.entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(e.getKey()).append("=").append(e.getValue());
            first = false;
        }
        return sb.toString();
    }
}

