/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reatomizer.block.entity;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.mcreator.reatomizer.ReatomizerMod;
import net.mcreator.reatomizer.config.ReatomizerConfig;
import net.mcreator.reatomizer.init.ReatomizerModBlockEntities;
import net.mcreator.reatomizer.init.ReatomizerModItems;
import net.mcreator.reatomizer.item.AtomBundleItem;
import net.mcreator.reatomizer.item.BlueprintItem;
import net.mcreator.reatomizer.util.ItemStackNbtUtil;
import net.mcreator.reatomizer.world.inventory.FabricatorGUIMenu;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class FabricatorBlockEntity
extends class_2621
implements class_1278 {
    private final Map<Integer, Long> lastInsertionTick = new HashMap<Integer, Long>();
    private class_2371<class_1799> stacks = class_2371.method_10213((int)30, (Object)class_1799.field_8037);
    private int computedRequired = -1;
    private long hiddenAtomCount = 0L;
    private int lastConsumedBundles = 0;
    private boolean funnelEnabled = false;
    private long lastFunnelExtractionGameTime = -1000L;

    public boolean isFunnelEnabled() {
        return this.funnelEnabled;
    }

    public void setFunnelEnabled(boolean enabled) {
        this.funnelEnabled = enabled;
        try {
            this.method_5431();
            if (this.field_11863 != null) {
                this.field_11863.method_8413(this.method_11016(), this.field_11863.method_8320(this.method_11016()), this.field_11863.method_8320(this.method_11016()), 3);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public FabricatorBlockEntity(class_2338 position, class_2680 state) {
        super(ReatomizerModBlockEntities.FABRICATOR, position, state);
    }

    public int getComputedRequired() {
        return this.computedRequired;
    }

    public long getHiddenAtomCount() {
        return this.hiddenAtomCount;
    }

    public long getTotalAtomBundleCount() {
        return this.hiddenAtomCount + (long)this.totalVisibleAtomBundles();
    }

    public int getLastConsumedBundles() {
        return this.lastConsumedBundles;
    }

    public void method_5447(int slot, class_1799 stack) {
        try {
            long MAX_TOTAL = 9999L;
            if (slot == 0 && stack != null && !stack.method_7960() && stack.method_7909() == ReatomizerModItems.ATOM_BUNDLE) {
                class_1799 currentInSlot = (class_1799)this.stacks.get(0);
                int currentSlotCount = currentInSlot != null && !currentInSlot.method_7960() ? currentInSlot.method_7947() : 0;
                long currentTotal = this.hiddenAtomCount;
                if (stack.method_7947() == 1 && currentSlotCount == 1 && currentTotal > 0L) {
                    ReatomizerMod.LOGGER.debug("Ignoring placeholder shuffle (count=1, total={})", (Object)currentTotal);
                    return;
                }
                long MAX_TOTAL_LOCAL = 9999L;
                long spaceAvailable = 9999L - currentTotal;
                if (spaceAvailable <= 0L) {
                    return;
                }
                int incomingCount = stack.method_7947();
                int toConsume = (int)Math.min((long)incomingCount, spaceAvailable);
                if (toConsume > 0) {
                    stack.method_7934(toConsume);
                    this.hiddenAtomCount += (long)toConsume;
                    ReatomizerMod.LOGGER.debug("setItem: incoming={}, consumed={}, new hidden={}, newTotal={}", (Object)incomingCount, (Object)toConsume, (Object)this.hiddenAtomCount, (Object)this.hiddenAtomCount);
                    this.stacks.set(0, (Object)class_1799.field_8037);
                }
                this.method_5431();
                if (this.field_11863 != null) {
                    this.field_11863.method_8413(this.method_11016(), this.field_11863.method_8320(this.method_11016()), this.field_11863.method_8320(this.method_11016()), 3);
                }
                return;
            }
            this.stacks.set(slot, (Object)(stack == null || stack.method_7960() ? class_1799.field_8037 : stack.method_7972()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public class_1799 method_5438(int slot) {
        if (slot == 0) {
            return class_1799.field_8037;
        }
        if (slot < 0 || slot >= this.stacks.size()) {
            return class_1799.field_8037;
        }
        class_1799 stack = (class_1799)this.stacks.get(slot);
        return stack == null ? class_1799.field_8037 : stack;
    }

    public void setStack(int slot, class_1799 stack) {
        if (slot < 0 || slot >= this.stacks.size()) {
            return;
        }
        class_1799 toStore = stack == null || stack.method_7960() ? class_1799.field_8037 : stack.method_7972();
        this.stacks.set(slot, (Object)toStore);
        this.normalizeAtomBundles();
    }

    private void logAtomBundleSlots(String context) {
        int[] atomSlots;
        StringBuilder sb = new StringBuilder("[" + context + "] Atom bundle slots: ");
        for (int si : atomSlots = new int[]{0}) {
            if (si < 0 || si >= this.stacks.size()) continue;
            class_1799 s = (class_1799)this.stacks.get(si);
            sb.append(String.format("[slot %d: %s x%d] ", si, s == null ? "null" : s.method_7909(), s == null ? 0 : s.method_7947()));
        }
        sb.append(String.format(" hidden=%d", this.hiddenAtomCount));
        ReatomizerMod.LOGGER.debug(sb.toString());
    }

    private void normalizeAtomBundles() {
        try {
            if (this.stacks == null || this.stacks.size() < 1) {
                return;
            }
            long MAX_TOTAL = 9999L;
            if (this.hiddenAtomCount < 0L) {
                this.hiddenAtomCount = 0L;
            }
            if (this.hiddenAtomCount > 9999L) {
                this.hiddenAtomCount = 9999L;
            }
            this.stacks.set(0, (Object)class_1799.field_8037);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void addAtomBundles(long amount) {
        if (amount <= 0L) {
            return;
        }
        long MAX_TOTAL = 9999L;
        try {
            class_1799 current = (class_1799)this.stacks.get(0);
            int currentVisible = current == null || current.method_7960() ? 0 : current.method_7947();
            long currentTotal = this.hiddenAtomCount + (long)currentVisible;
            long combined = currentTotal + amount;
            if (combined > 9999L) {
                combined = 9999L;
            }
            this.hiddenAtomCount = combined;
            this.normalizeAtomBundles();
            this.logAtomBundleSlots("After addAtomBundles");
            try {
                this.method_5431();
                if (this.field_11863 != null) {
                    this.field_11863.method_8413(this.method_11016(), this.field_11863.method_8320(this.method_11016()), this.field_11863.method_8320(this.method_11016()), 3);
                }
            }
            catch (Throwable throwable) {}
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void method_11014(class_11368 valueInput) {
        super.method_11014(valueInput);
        if (!this.method_54871(valueInput)) {
            this.stacks = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        }
        class_1262.method_5429((class_11368)valueInput, this.stacks);
        try {
            Optional maybeHidden = valueInput.method_71440("hiddenAtomCount");
            this.hiddenAtomCount = maybeHidden.orElse(0L);
            ReatomizerMod.LOGGER.debug("Loaded hiddenAtomCount: {}", (Object)this.hiddenAtomCount);
        }
        catch (Throwable t) {
            this.hiddenAtomCount = 0L;
            ReatomizerMod.LOGGER.warn("Failed to load hiddenAtomCount, defaulting to 0", t);
        }
        try {
            Optional maybeFunnel = valueInput.method_71440("funnelEnabled");
            long val = maybeFunnel.orElse(0L);
            this.funnelEnabled = val != 0L;
            ReatomizerMod.LOGGER.debug("Loaded funnelEnabled: {}", (Object)this.funnelEnabled);
        }
        catch (Throwable t) {
            this.funnelEnabled = false;
            ReatomizerMod.LOGGER.warn("Failed to load funnelEnabled, defaulting to false", t);
        }
        this.normalizeAtomBundles();
    }

    public void method_11007(class_11372 valueOutput) {
        super.method_11007(valueOutput);
        if (!this.method_54872(valueOutput)) {
            class_1262.method_5426((class_11372)valueOutput, this.stacks);
        }
        try {
            valueOutput.method_71466("hiddenAtomCount", this.hiddenAtomCount);
            ReatomizerMod.LOGGER.debug("Saved hiddenAtomCount: {}", (Object)this.hiddenAtomCount);
        }
        catch (Throwable t) {
            ReatomizerMod.LOGGER.error("Failed to save hiddenAtomCount", t);
        }
        try {
            valueOutput.method_71466("funnelEnabled", this.funnelEnabled ? 1L : 0L);
            ReatomizerMod.LOGGER.debug("Saved funnelEnabled: {}", (Object)this.funnelEnabled);
        }
        catch (Throwable t) {
            ReatomizerMod.LOGGER.error("Failed to save funnelEnabled", t);
        }
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 lookupProvider) {
        return this.method_38242(lookupProvider);
    }

    public void saveToItem(class_1799 stack, class_7225.class_7874 registries) {
        block34: {
            try {
                class_2487 itemTag;
                block36: {
                    class_2487 tag;
                    block35: {
                        block33: {
                            block32: {
                                block31: {
                                    tag = this.method_38242(registries);
                                    try {
                                        if (ReatomizerConfig.INSTANCE != null && ReatomizerConfig.INSTANCE.DEBUG_NBT) {
                                            ReatomizerMod.LOGGER.debug("saveToItem: original BE tag is {}", (Object)(tag == null ? "null" : tag.toString()));
                                            FabricatorBlockEntity.debugLogItemsTag(tag, "saveToItem:beforeNormalize");
                                        }
                                    }
                                    catch (Throwable tLog) {
                                        if (ReatomizerConfig.INSTANCE == null || !ReatomizerConfig.INSTANCE.DEBUG_NBT) break block31;
                                        ReatomizerMod.LOGGER.warn("saveToItem: failed to log original tag", tLog);
                                    }
                                }
                                try {
                                    try {
                                        class_2487 comps;
                                        if (tag == null || tag.method_33133() || (comps = ItemStackNbtUtil.safeGetCompound(tag, "components")) == null) break block32;
                                        class_2487 customData = ItemStackNbtUtil.safeGetCompound(comps, "minecraft:custom_data");
                                        try {
                                            Method[] nestedBe;
                                            if (customData == null || (nestedBe = ItemStackNbtUtil.safeGetCompound(customData, "BlockEntityTag")) != null && !nestedBe.method_33133()) break block32;
                                            try {
                                                customData.method_10566("BlockEntityTag", (class_2520)tag.method_10553());
                                            }
                                            catch (Throwable ignoredCopy) {
                                                try {
                                                    customData.method_10566("BlockEntityTag", (class_2520)tag);
                                                }
                                                catch (Throwable throwable) {}
                                            }
                                        }
                                        catch (Throwable nestedBe) {
                                        }
                                    }
                                    catch (Throwable comps) {}
                                }
                                catch (Throwable comps) {
                                    // empty catch block
                                }
                            }
                            try {
                                if (ReatomizerConfig.INSTANCE != null && ReatomizerConfig.INSTANCE.DEBUG_NBT) {
                                    ReatomizerMod.LOGGER.debug("saveToItem: normalized BE tag is {}", (Object)(tag == null ? "null" : tag.toString()));
                                    FabricatorBlockEntity.debugLogItemsTag(tag, "saveToItem:afterNormalize");
                                }
                            }
                            catch (Throwable tLog2) {
                                if (ReatomizerConfig.INSTANCE == null || !ReatomizerConfig.INSTANCE.DEBUG_NBT) break block33;
                                ReatomizerMod.LOGGER.warn("saveToItem: failed to log normalized tag", tLog2);
                            }
                        }
                        if (tag == null || tag.method_33133() || (itemTag = ItemStackNbtUtil.getOrCreateTag(stack)) == null) break block34;
                        itemTag.method_10566("BlockEntityTag", (class_2520)tag);
                        try {
                            if (ReatomizerConfig.INSTANCE != null && ReatomizerConfig.INSTANCE.DEBUG_NBT) {
                                ReatomizerMod.LOGGER.debug("saveToItem: final itemTag being written: {}", (Object)itemTag.toString());
                                FabricatorBlockEntity.debugLogItemsTag(itemTag, "saveToItem:itemTag");
                            }
                        }
                        catch (Throwable tLog3) {
                            if (ReatomizerConfig.INSTANCE == null || !ReatomizerConfig.INSTANCE.DEBUG_NBT) break block35;
                            ReatomizerMod.LOGGER.warn("saveToItem: failed to log final itemTag", tLog3);
                        }
                    }
                    try {
                        try {
                            Method getOrCreate = null;
                            for (Method m : class_1799.class.getMethods()) {
                                if (!m.getName().equals("getOrCreateTag") || m.getParameterCount() != 0) continue;
                                getOrCreate = m;
                                break;
                            }
                            if (getOrCreate != null) {
                                Object vanillaTagObj = getOrCreate.invoke((Object)stack, new Object[0]);
                                if (vanillaTagObj instanceof class_2487) {
                                    ((class_2487)vanillaTagObj).method_10566("BlockEntityTag", (class_2520)tag.method_10553());
                                }
                                break block36;
                            }
                            try {
                                Method getTag = class_1799.class.getMethod("getTag", new Class[0]);
                                Method setTag = class_1799.class.getMethod("setTag", class_2487.class);
                                Object maybe = getTag.invoke((Object)stack, new Object[0]);
                                class_2487 vanilla = maybe instanceof class_2487 ? (class_2487)maybe : new class_2487();
                                vanilla.method_10566("BlockEntityTag", (class_2520)tag.method_10553());
                                if (setTag != null) {
                                    setTag.invoke((Object)stack, vanilla);
                                }
                            }
                            catch (Throwable throwable) {
                            }
                        }
                        catch (Throwable throwable) {}
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ItemStackNbtUtil.writeTag(stack, itemTag);
            }
            catch (Throwable t) {
                ReatomizerMod.LOGGER.warn("Failed to attach BlockEntity data to item", t);
            }
        }
    }

    public int method_5439() {
        return this.stacks.size();
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.stacks) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_2561 method_17823() {
        return class_2561.method_43470((String)"fabricator");
    }

    public int method_5444() {
        return 64;
    }

    public class_1703 method_5465(int id, class_1661 inventory) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10807(this.method_11016());
        return new FabricatorGUIMenu(id, inventory, (class_1263)this, buf);
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Fabricator");
    }

    protected class_2371<class_1799> method_11282() {
        return this.stacks;
    }

    protected void method_11281(class_2371<class_1799> stacks) {
        this.stacks = stacks;
        this.normalizeAtomBundles();
    }

    public class_1799 getStack(int index) {
        if (this.stacks == null) {
            return class_1799.field_8037;
        }
        if (index < 0 || index >= this.stacks.size()) {
            return class_1799.field_8037;
        }
        class_1799 s = (class_1799)this.stacks.get(index);
        return s == null ? class_1799.field_8037 : s;
    }

    private int totalVisibleAtomBundles() {
        int[] atomSlots = new int[]{0};
        int sum = 0;
        for (int si : atomSlots) {
            class_1799 s;
            if (si < 0 || si >= this.stacks.size() || (s = (class_1799)this.stacks.get(si)) == null || s.method_7960() || s.method_7909() != ReatomizerModItems.ATOM_BUNDLE) continue;
            sum += s.method_7947();
        }
        return sum;
    }

    public static void debugLogItemsTag(class_2487 beTag, String context) {
        try {
            if (ReatomizerConfig.INSTANCE == null || !ReatomizerConfig.INSTANCE.DEBUG_NBT) {
                return;
            }
            if (beTag == null) {
                ReatomizerMod.LOGGER.debug("debugLogItemsTag {}: beTag is null", (Object)context);
                return;
            }
            class_2499 items = ItemStackNbtUtil.safeGetCompoundList(beTag, "Items");
            if (items == null) {
                ReatomizerMod.LOGGER.debug("debugLogItemsTag {}: Items list is null", (Object)context);
                return;
            }
            ReatomizerMod.LOGGER.debug("debugLogItemsTag {}: Items size={}", (Object)context, (Object)items.size());
            for (int i = 0; i < items.size(); ++i) {
                try {
                    class_2520 t = items.method_10534(i);
                    if (t == null) {
                        ReatomizerMod.LOGGER.debug("debugLogItemsTag {}: item[{}]=null", (Object)context, (Object)i);
                        continue;
                    }
                    ReatomizerMod.LOGGER.debug("debugLogItemsTag {}: item[{}]={}", (Object)context, (Object)i, (Object)t.toString());
                    continue;
                }
                catch (Throwable tInner) {
                    ReatomizerMod.LOGGER.warn("debugLogItemsTag {}: failed to read item[{}]", (Object)context, (Object)i, (Object)tInner);
                }
            }
        }
        catch (Throwable e) {
            ReatomizerMod.LOGGER.warn("debugLogItemsTag {}: exception while logging items", (Object)context, (Object)e);
        }
    }

    public void addHiddenAtoms(long amount) {
        if (amount <= 0L) {
            return;
        }
        this.hiddenAtomCount += amount;
        try {
            this.method_5431();
            if (this.field_11863 != null) {
                this.field_11863.method_8413(this.method_11016(), this.field_11863.method_8320(this.method_11016()), this.field_11863.method_8320(this.method_11016()), 3);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private int consumeAtomBundles(int amount) {
        ReatomizerMod.LOGGER.debug("consumeAtomBundles called with amount={}", (Object)amount);
        if (amount <= 0) {
            return 0;
        }
        long totalAvailable = this.hiddenAtomCount;
        ReatomizerMod.LOGGER.debug("consumeAtomBundles totals: visible=0, hidden={}, totalAvailable={}", (Object)this.hiddenAtomCount, (Object)totalAvailable);
        long willConsumeLong = Math.min(totalAvailable, (long)amount);
        int willConsume = (int)willConsumeLong;
        if (willConsume <= 0) {
            ReatomizerMod.LOGGER.debug("No atom bundles available to consume (need {}, have {}), aborting.", (Object)amount, (Object)totalAvailable);
            return 0;
        }
        this.hiddenAtomCount -= (long)willConsume;
        int consumed = willConsume;
        this.normalizeAtomBundles();
        this.logAtomBundleSlots("After consumption");
        ReatomizerMod.LOGGER.debug("consumeAtomBundles result: consumed={}, requested={}, remaining_hidden={}", (Object)consumed, (Object)amount, (Object)this.hiddenAtomCount);
        if (consumed > 0) {
            try {
                this.method_5431();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                if (this.field_11863 != null) {
                    this.field_11863.method_8413(this.method_11016(), this.field_11863.method_8320(this.method_11016()), this.field_11863.method_8320(this.method_11016()), 3);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return consumed;
    }

    public int extractAtomBundles(int amount) {
        return this.consumeAtomBundles(amount);
    }

    private int computeRequiredBundles(class_1799 stored, class_1799 blueprint) {
        try {
            int tagOverride = BlueprintItem.getRequiredBundles(blueprint);
            if (tagOverride > 0) {
                return tagOverride;
            }
            int enchantCount = 0;
            try {
                class_9304 ench;
                if (blueprint != null && !blueprint.method_7960() && blueprint.method_57826(class_9334.field_49633) && (ench = (class_9304)blueprint.method_58694(class_9334.field_49633)) != null) {
                    enchantCount = ench.method_57541();
                }
            }
            catch (Throwable ench) {
                // empty catch block
            }
            int base = ReatomizerConfig.INSTANCE != null ? ReatomizerConfig.INSTANCE.atomBundlesToFabricate : 100;
            int perEnchant = ReatomizerConfig.INSTANCE != null ? ReatomizerConfig.INSTANCE.atomBundlesPerEnchant : 20;
            int required = Math.max(0, base + perEnchant * enchantCount);
            class_1814 rarity = class_1814.field_8906;
            try {
                if (stored != null && !stored.method_7960()) {
                    rarity = stored.method_7932();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int multiplier = 1;
            switch (rarity) {
                case field_8907: {
                    multiplier = 2;
                    break;
                }
                case field_8903: {
                    multiplier = 3;
                    break;
                }
                case field_8904: {
                    multiplier = 5;
                    break;
                }
                default: {
                    multiplier = 1;
                }
            }
            required = Math.max(1, required * multiplier);
            return required;
        }
        catch (Throwable t) {
            int fallback = ReatomizerConfig.INSTANCE != null ? ReatomizerConfig.INSTANCE.atomBundlesToFabricate : 100;
            return Math.max(1, fallback);
        }
    }

    public void preparePreview() {
        try {
            if (this.field_11863 == null) {
                return;
            }
            if (this.field_11863.method_8608()) {
                return;
            }
            if (this.stacks == null || this.stacks.size() < 3) {
                return;
            }
            class_1799 blueprint = (class_1799)this.stacks.get(1);
            if (blueprint == null || blueprint.method_7960()) {
                this.stacks.set(2, (Object)class_1799.field_8037);
                if (this.computedRequired != -1) {
                    this.computedRequired = -1;
                    try {
                        this.method_5431();
                        if (this.field_11863 != null) {
                            this.field_11863.method_8413(this.method_11016(), this.field_11863.method_8320(this.method_11016()), this.field_11863.method_8320(this.method_11016()), 3);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                return;
            }
            class_1799 stored = BlueprintItem.getStoredTarget(blueprint);
            int required = this.computeRequiredBundles(stored, blueprint);
            if (this.computedRequired != required) {
                this.computedRequired = required;
                try {
                    this.method_5431();
                    if (this.field_11863 != null) {
                        this.field_11863.method_8413(this.method_11016(), this.field_11863.method_8320(this.method_11016()), this.field_11863.method_8320(this.method_11016()), 3);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (stored == null || stored.method_7960() || required <= 0) {
                this.stacks.set(2, (Object)class_1799.field_8037);
                this.method_5431();
                return;
            }
            long totalAvailable = this.hiddenAtomCount;
            if (totalAvailable < (long)required) {
                this.stacks.set(2, (Object)class_1799.field_8037);
                this.method_5431();
                return;
            }
            class_1799 result = stored.method_7972();
            try {
                class_9304 enchants;
                if (blueprint.method_57826(class_9334.field_49633) && (enchants = (class_9304)blueprint.method_58694(class_9334.field_49633)) != null) {
                    for (Object2IntMap.Entry entry : enchants.method_57539()) {
                        result.method_7978((class_6880)entry.getKey(), entry.getValue().intValue());
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.stacks.set(2, (Object)result);
            this.method_5431();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public boolean completeFabricationOnTake() {
        try {
            try {
                this.preparePreview();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                ReatomizerMod.LOGGER.debug("completeFabricationOnTake: enter level={} clientSide={} stacksSize={}", (Object)this.field_11863, this.field_11863 != null ? Boolean.valueOf(this.field_11863.method_8608()) : "null", this.stacks != null ? Integer.valueOf(this.stacks.size()) : "null");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (this.field_11863 == null) {
                ReatomizerMod.LOGGER.debug("completeFabricationOnTake: aborting - level is null");
                return false;
            }
            if (this.field_11863.method_8608()) {
                ReatomizerMod.LOGGER.debug("completeFabricationOnTake: aborting - client side");
                return false;
            }
            if (this.stacks == null || this.stacks.size() < 3) {
                ReatomizerMod.LOGGER.debug("completeFabricationOnTake: aborting - invalid stacks (null or size<3)");
                return false;
            }
            this.lastConsumedBundles = 0;
            class_1799 blueprint = (class_1799)this.stacks.get(1);
            if (blueprint == null || blueprint.method_7960()) {
                ReatomizerMod.LOGGER.debug("completeFabricationOnTake: aborting - no blueprint in slot 1");
                return false;
            }
            class_1799 stored = BlueprintItem.getStoredTarget(blueprint);
            try {
                ReatomizerMod.LOGGER.debug("completeFabricationOnTake: blueprint present, storedTarget={}", (Object)stored);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int required = this.computeRequiredBundles(stored, blueprint);
            ReatomizerMod.LOGGER.debug("completeFabricationOnTake: requiredBundles={}", (Object)required);
            if (required <= 0) {
                ReatomizerMod.LOGGER.debug("completeFabricationOnTake: aborting - required bundles <= 0 ({})", (Object)required);
                return false;
            }
            long totalAvailable = this.hiddenAtomCount;
            ReatomizerMod.LOGGER.debug("completeFabricationOnTake: totalAvailable(hiddenAtomCount)={}", (Object)totalAvailable);
            if (totalAvailable < (long)required) {
                ReatomizerMod.LOGGER.debug("completeFabricationOnTake: aborting - not enough bundles (need {}, have {})", (Object)required, (Object)totalAvailable);
                return false;
            }
            class_1799 output = (class_1799)this.stacks.get(2);
            class_1799 expectedPreview = class_1799.field_8037;
            if (stored != null && !stored.method_7960()) {
                expectedPreview = stored.method_7972();
                try {
                    class_9304 enchants;
                    if (blueprint != null && !blueprint.method_7960() && blueprint.method_57826(class_9334.field_49633) && (enchants = (class_9304)blueprint.method_58694(class_9334.field_49633)) != null) {
                        for (Object2IntMap.Entry entry : enchants.method_57539()) {
                            expectedPreview.method_7978((class_6880)entry.getKey(), entry.getValue().intValue());
                        }
                    }
                }
                catch (Throwable enchants) {
                    // empty catch block
                }
            }
            if (output == null || output.method_7960() || !class_1799.method_31577((class_1799)output, (class_1799)expectedPreview)) {
                ReatomizerMod.LOGGER.debug("completeFabricationOnTake: aborting - output mismatch or empty. output={}, expected={}", (Object)output, (Object)expectedPreview);
                return false;
            }
            ReatomizerMod.LOGGER.debug("completeFabricationOnTake: attempting to consume {} bundles", (Object)required);
            int consumed = this.consumeAtomBundles(required);
            ReatomizerMod.LOGGER.debug("completeFabricationOnTake: consumeAtomBundles returned consumed={} hiddenRemaining={}", (Object)consumed, (Object)this.hiddenAtomCount);
            if (consumed < required) {
                this.lastConsumedBundles = 0;
                ReatomizerMod.LOGGER.warn("completeFabricationOnTake: consumption shortfall (required={}, consumed={})", (Object)required, (Object)consumed);
                return false;
            }
            this.lastConsumedBundles = consumed;
            ReatomizerMod.LOGGER.debug("completeFabricationOnTake: fabrication succeeded, consumed {} bundles, hidden remaining {}", (Object)consumed, (Object)this.hiddenAtomCount);
            if (!((class_1799)this.stacks.get(2)).method_7960()) {
                this.stacks.set(2, (Object)class_1799.field_8037);
            }
            this.method_5431();
            return true;
        }
        catch (Throwable t) {
            ReatomizerMod.LOGGER.error("Exception in completeFabricationOnTake", t);
            return false;
        }
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, FabricatorBlockEntity entity) {
        if (entity == null) {
            return;
        }
        entity.preparePreview();
    }

    public class_1799 fabricateAndReturnResult() {
        try {
            class_1799 output = this.getStack(2);
            if (output == null || output.method_7960()) {
                return class_1799.field_8037;
            }
            class_1799 copy = output.method_7972();
            boolean ok = this.completeFabricationOnTake();
            if (ok) {
                return copy;
            }
            return class_1799.field_8037;
        }
        catch (Throwable t) {
            ReatomizerMod.LOGGER.error("fabricateAndReturnResult exception", t);
            return class_1799.field_8037;
        }
    }

    public class_1799 onTakeCraftResult() {
        try {
            return this.fabricateAndReturnResult();
        }
        catch (Throwable t) {
            ReatomizerMod.LOGGER.error("onTakeCraftResult: exception delegating to fabricateAndReturnResult", t);
            return class_1799.field_8037;
        }
    }

    public void dropContents(class_1937 level, class_2338 pos) {
    }

    public boolean method_5437(int index, class_1799 stack) {
        if (stack == null || stack.method_7960()) {
            return false;
        }
        if (index == 1) {
            return stack.method_7909() == ReatomizerModItems.BLUEPRINT;
        }
        if (index == 2) {
            return false;
        }
        if (index == 0) {
            class_1799 current = (class_1799)this.stacks.get(index);
            if (current == null || current.method_7960() || current.method_7947() >= 64) {
                // empty if block
            }
            boolean allowed = stack.method_7909() instanceof AtomBundleItem || stack.method_7909() == ReatomizerModItems.ATOM_BUNDLE;
            return allowed;
        }
        return false;
    }

    public int[] method_5494(class_2350 side) {
        try {
            if (this.funnelEnabled) {
                return new int[]{0, 2};
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (side == class_2350.field_11033) {
            return new int[0];
        }
        return new int[]{0};
    }

    public boolean method_5492(int index, class_1799 itemstack, @Nullable class_2350 direction) {
        if (direction == class_2350.field_11033) {
            return false;
        }
        if (index == 2) {
            return false;
        }
        return this.method_5437(index, itemstack);
    }

    public boolean method_5493(int index, class_1799 itemstack, class_2350 direction) {
        block6: {
            if (!this.funnelEnabled || index != 2) break block6;
            try {
                if (this.field_11863 == null) {
                    return false;
                }
                long now = this.field_11863.method_8510();
                return now - this.lastFunnelExtractionGameTime >= 20L;
            }
            catch (Throwable ignoredInner) {
                try {
                    return false;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public class_1799 method_5434(int index, int count) {
        block14: {
            try {
                if (index != 2 || !this.funnelEnabled) break block14;
                if (this.field_11863 == null || this.field_11863.method_8608()) {
                    return super.method_5434(index, count);
                }
                try {
                    this.preparePreview();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                class_1799 output = (class_1799)this.stacks.get(2);
                if (output == null || output.method_7960()) {
                    return super.method_5434(index, count);
                }
                class_1799 blueprint = (class_1799)this.stacks.get(1);
                class_1799 stored = BlueprintItem.getStoredTarget(blueprint);
                int required = this.computeRequiredBundles(stored, blueprint);
                if (required <= 0) {
                    return super.method_5434(index, count);
                }
                int consumed = this.consumeAtomBundles(required);
                if (consumed < required) {
                    return class_1799.field_8037;
                }
                this.lastConsumedBundles = consumed;
                class_1799 copy = output.method_7972();
                this.stacks.set(2, (Object)class_1799.field_8037);
                try {
                    if (this.field_11863 != null) {
                        this.lastFunnelExtractionGameTime = this.field_11863.method_8510();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    this.method_5431();
                    if (this.field_11863 != null) {
                        this.field_11863.method_8413(this.method_11016(), this.field_11863.method_8320(this.method_11016()), this.field_11863.method_8320(this.method_11016()), 3);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return copy;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return super.method_5434(index, count);
    }
}

