/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reatomizer.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public class ReatomizerConfig {
    public static final int DEFAULT_ATOM_BUNDLES_PER_ITEM = 1;
    public static final int DEFAULT_ATOM_BUNDLES_TO_FABRICATE = 100;
    public static final int DEFAULT_ATOM_BUNDLES_PER_ENCHANT = 20;
    public static final int DEFAULT_RARITY_MULTIPLIER_COMMON = 1;
    public static final int DEFAULT_RARITY_MULTIPLIER_UNCOMMON = 2;
    public static final int DEFAULT_RARITY_MULTIPLIER_RARE = 3;
    public static final int DEFAULT_RARITY_MULTIPLIER_EPIC = 5;
    public static final boolean DEFAULT_DEBUG_NBT = false;
    public static final int MIN_ATOM_BUNDLES = 0;
    public static final int MAX_ATOM_BUNDLES = 1000000;
    public static final int MIN_RARITY_MULTIPLIER = 1;
    public static final int MAX_RARITY_MULTIPLIER = 100;
    public int atomBundlesPerItem = 1;
    public int atomBundlesToFabricate = 100;
    public int atomBundlesPerEnchant = 20;
    public boolean DEBUG_NBT = false;
    public int rarityMultiplierCommon = 1;
    public int rarityMultiplierUncommon = 2;
    public int rarityMultiplierRare = 3;
    public int rarityMultiplierEpic = 5;
    public List<String> blueprintBlacklist = ReatomizerConfig.createDefaultBlacklist();
    public List<String> atomizerBlacklist = ReatomizerConfig.createDefaultAtomizerBlacklist();
    public static final String CONFIG_FILE = "config/reatomizer.json";
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static ReatomizerConfig INSTANCE = new ReatomizerConfig();

    private static List<String> createDefaultBlacklist() {
        ArrayList<String> defaults = new ArrayList<String>();
        defaults.add("minecraft:air");
        defaults.add("minecraft:bedrock");
        defaults.add("minecraft:barrier");
        defaults.add("minecraft:command_block");
        defaults.add("minecraft:chain_command_block");
        defaults.add("minecraft:repeating_command_block");
        defaults.add("minecraft:structure_block");
        defaults.add("minecraft:structure_void");
        defaults.add("minecraft:jigsaw");
        return defaults;
    }

    private static List<String> createDefaultAtomizerBlacklist() {
        ArrayList<String> defaults = new ArrayList<String>();
        defaults.add("minecraft:air");
        defaults.add("minecraft:bedrock");
        defaults.add("minecraft:barrier");
        defaults.add("minecraft:command_block");
        defaults.add("minecraft:chain_command_block");
        defaults.add("minecraft:repeating_command_block");
        return defaults;
    }

    public static void applyDefaultsAndSave() {
        if (INSTANCE == null) {
            INSTANCE = new ReatomizerConfig();
        }
        ReatomizerConfig.INSTANCE.atomBundlesPerItem = 1;
        ReatomizerConfig.INSTANCE.atomBundlesToFabricate = 100;
        ReatomizerConfig.INSTANCE.atomBundlesPerEnchant = 20;
        ReatomizerConfig.INSTANCE.rarityMultiplierCommon = 1;
        ReatomizerConfig.INSTANCE.rarityMultiplierUncommon = 2;
        ReatomizerConfig.INSTANCE.rarityMultiplierRare = 3;
        ReatomizerConfig.INSTANCE.rarityMultiplierEpic = 5;
        ReatomizerConfig.INSTANCE.DEBUG_NBT = false;
        ReatomizerConfig.INSTANCE.blueprintBlacklist = ReatomizerConfig.createDefaultBlacklist();
        ReatomizerConfig.INSTANCE.atomizerBlacklist = ReatomizerConfig.createDefaultAtomizerBlacklist();
        ReatomizerConfig.save();
    }

    public static boolean clampAndSave() {
        if (INSTANCE == null) {
            INSTANCE = new ReatomizerConfig();
        }
        boolean ok = true;
        if (ReatomizerConfig.INSTANCE.atomBundlesPerItem < 0) {
            ReatomizerConfig.INSTANCE.atomBundlesPerItem = 0;
            ok = false;
        } else if (ReatomizerConfig.INSTANCE.atomBundlesPerItem > 1000000) {
            ReatomizerConfig.INSTANCE.atomBundlesPerItem = 1000000;
            ok = false;
        }
        if (ReatomizerConfig.INSTANCE.atomBundlesToFabricate < 0) {
            ReatomizerConfig.INSTANCE.atomBundlesToFabricate = 0;
            ok = false;
        } else if (ReatomizerConfig.INSTANCE.atomBundlesToFabricate > 1000000) {
            ReatomizerConfig.INSTANCE.atomBundlesToFabricate = 1000000;
            ok = false;
        }
        if (ReatomizerConfig.INSTANCE.atomBundlesPerEnchant < 0) {
            ReatomizerConfig.INSTANCE.atomBundlesPerEnchant = 0;
            ok = false;
        } else if (ReatomizerConfig.INSTANCE.atomBundlesPerEnchant > 1000000) {
            ReatomizerConfig.INSTANCE.atomBundlesPerEnchant = 1000000;
            ok = false;
        }
        if (ReatomizerConfig.INSTANCE.rarityMultiplierCommon < 1) {
            ReatomizerConfig.INSTANCE.rarityMultiplierCommon = 1;
            ok = false;
        } else if (ReatomizerConfig.INSTANCE.rarityMultiplierCommon > 100) {
            ReatomizerConfig.INSTANCE.rarityMultiplierCommon = 100;
            ok = false;
        }
        if (ReatomizerConfig.INSTANCE.rarityMultiplierUncommon < 1) {
            ReatomizerConfig.INSTANCE.rarityMultiplierUncommon = 1;
            ok = false;
        } else if (ReatomizerConfig.INSTANCE.rarityMultiplierUncommon > 100) {
            ReatomizerConfig.INSTANCE.rarityMultiplierUncommon = 100;
            ok = false;
        }
        if (ReatomizerConfig.INSTANCE.rarityMultiplierRare < 1) {
            ReatomizerConfig.INSTANCE.rarityMultiplierRare = 1;
            ok = false;
        } else if (ReatomizerConfig.INSTANCE.rarityMultiplierRare > 100) {
            ReatomizerConfig.INSTANCE.rarityMultiplierRare = 100;
            ok = false;
        }
        if (ReatomizerConfig.INSTANCE.rarityMultiplierEpic < 1) {
            ReatomizerConfig.INSTANCE.rarityMultiplierEpic = 1;
            ok = false;
        } else if (ReatomizerConfig.INSTANCE.rarityMultiplierEpic > 100) {
            ReatomizerConfig.INSTANCE.rarityMultiplierEpic = 100;
            ok = false;
        }
        ReatomizerConfig.save();
        return ok;
    }

    public static void load() {
        File file = new File(CONFIG_FILE);
        if (file.exists()) {
            try (FileReader reader = new FileReader(file);){
                ReatomizerConfig loaded = (ReatomizerConfig)GSON.fromJson((Reader)reader, ReatomizerConfig.class);
                if (loaded != null) {
                    INSTANCE = loaded;
                    if (ReatomizerConfig.INSTANCE.blueprintBlacklist == null) {
                        ReatomizerConfig.INSTANCE.blueprintBlacklist = ReatomizerConfig.createDefaultBlacklist();
                    }
                    if (ReatomizerConfig.INSTANCE.atomizerBlacklist == null) {
                        ReatomizerConfig.INSTANCE.atomizerBlacklist = ReatomizerConfig.createDefaultAtomizerBlacklist();
                    }
                    ReatomizerConfig.clampAndSave();
                } else {
                    ReatomizerConfig.applyDefaultsAndSave();
                }
            }
            catch (JsonSyntaxException | IOException e) {
                System.err.println("[Reatomizer] Failed to load config: " + e.getMessage());
                ReatomizerConfig.applyDefaultsAndSave();
            }
        } else {
            ReatomizerConfig.save();
        }
    }

    public static void save() {
        File file = new File(CONFIG_FILE);
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("[Reatomizer] Failed to save config: " + e.getMessage());
        }
    }
}

