/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reatomizer.init;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.mcreator.reatomizer.init.ReatomizerModScreens;
import net.mcreator.reatomizer.network.MenuStateUpdateMessage;
import net.mcreator.reatomizer.world.inventory.AtomizerGUIMenu;
import net.mcreator.reatomizer.world.inventory.FabricatorGUIMenu;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_437;
import net.minecraft.class_7701;
import net.minecraft.class_7923;

public class ReatomizerModMenus {
    public static class_3917<AtomizerGUIMenu> ATOMIZER_GUI;
    public static class_3917<FabricatorGUIMenu> FABRICATOR_GUI;
    private static final AtomicInteger MENU_STATE_CORRELATION;
    private static final ConcurrentHashMap<String, class_2338> LAST_OPEN_MENU_POS;
    private static final ConcurrentHashMap<String, Integer> LAST_APPLIED_CIDS;
    public static final ConcurrentHashMap<String, MenuStateUpdateMessage> CLIENT_PENDING;

    public static int getLastAppliedCid(String key) {
        try {
            return LAST_APPLIED_CIDS.getOrDefault(key, 0);
        }
        catch (Throwable ignored) {
            return 0;
        }
    }

    public static void setLastAppliedCid(String key, int cid) {
        if (key == null) {
            return;
        }
        try {
            LAST_APPLIED_CIDS.put(key, cid);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void registerOpenMenu(class_3222 player, class_2338 pos) {
        if (player == null || pos == null) {
            return;
        }
        try {
            LAST_OPEN_MENU_POS.put(player.method_7334().getId().toString(), pos);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class_2338 getLastOpenMenuPos(class_3222 player) {
        if (player == null) {
            return null;
        }
        try {
            return LAST_OPEN_MENU_POS.get(player.method_7334().getId().toString());
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    public static void unregisterOpenMenu(class_3222 player) {
        if (player == null) {
            return;
        }
        try {
            LAST_OPEN_MENU_POS.remove(player.method_7334().getId().toString());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void load() {
        ATOMIZER_GUI = ReatomizerModMenus.register("atomizer_gui", AtomizerGUIMenu::new);
        AtomizerGUIMenu.screenInit();
        FABRICATOR_GUI = ReatomizerModMenus.register("fabricator_gui", FabricatorGUIMenu::new);
        FabricatorGUIMenu.screenInit();
        ServerPlayNetworking.registerGlobalReceiver((class_2960)MenuStateUpdateMessage.ID, (server, player, handler, buf, responseSender) -> {
            MenuStateUpdateMessage message = MenuStateUpdateMessage.read(buf);
            MenuStateUpdateMessage.handleMenuState(message, player, responseSender);
        });
    }

    public static void clientLoad() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)MenuStateUpdateMessage.ID, (client, handler, buf, responseSender) -> {
            MenuStateUpdateMessage message = MenuStateUpdateMessage.read(buf);
            MenuStateUpdateMessage.handleClientMenuState(message, client, responseSender);
        });
    }

    private static <M extends class_1703> class_3917<M> register(String registryname, class_3917.class_3918<M> element) {
        return (class_3917)class_2378.method_10230((class_2378)class_7923.field_41187, (class_2960)class_2960.method_12829((String)("reatomizer:" + registryname)), (Object)new class_3917(element, class_7701.field_40183));
    }

    static {
        MENU_STATE_CORRELATION = new AtomicInteger(1);
        LAST_OPEN_MENU_POS = new ConcurrentHashMap();
        LAST_APPLIED_CIDS = new ConcurrentHashMap();
        CLIENT_PENDING = new ConcurrentHashMap();
    }

    public static interface MenuAccessor {
        public Map<String, Object> getMenuState();

        public Map<Integer, class_1735> getSlots();

        default public void sendMenuStateUpdate(class_1657 player, int elementType, String name, Object elementState, boolean needClientUpdate) {
            int cz;
            int cy;
            int cx;
            int correlationId;
            block15: {
                correlationId = MENU_STATE_CORRELATION.getAndIncrement();
                String coordSource = "messageCoords";
                try {
                    if (this instanceof FabricatorGUIMenu) {
                        coordSource = "menuCoords";
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                this.getMenuState().put(elementType + ":" + name, elementState);
                cx = 0;
                cy = 0;
                cz = 0;
                String coordsUsed = "none";
                try {
                    MenuAccessor menuAccessor = this;
                    if (!(menuAccessor instanceof FabricatorGUIMenu)) break block15;
                    FabricatorGUIMenu fg = (FabricatorGUIMenu)menuAccessor;
                    try {
                        Object mb = this.getMenuState().get("__menu_block_pos");
                        if (mb instanceof class_2338) {
                            class_2338 bp = (class_2338)mb;
                            cx = bp.method_10263();
                            cy = bp.method_10264();
                            cz = bp.method_10260();
                            coordsUsed = "menuBlockPos";
                            break block15;
                        }
                        cx = fg.x;
                        cy = fg.y;
                        cz = fg.z;
                        coordsUsed = "menuCoords";
                    }
                    catch (Throwable ignoredInner) {
                        cx = fg.x;
                        cy = fg.y;
                        cz = fg.z;
                        coordsUsed = "menuCoordsErr";
                    }
                }
                catch (Throwable fg) {
                    // empty catch block
                }
            }
            try {
                this.getMenuState().put("__last_sent_coords", new int[]{cx, cy, cz});
                this.getMenuState().put("__last_sent_cid", correlationId);
            }
            catch (Throwable fg) {
                // empty catch block
            }
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                buf = PacketByteBufs.create();
                MenuStateUpdateMessage.write(buf, new MenuStateUpdateMessage(elementType, name, elementState, cx, cy, cz, correlationId));
                ServerPlayNetworking.send((class_3222)serverPlayer, (class_2960)MenuStateUpdateMessage.ID, (class_2540)buf);
            } else if (player.method_37908().field_9236) {
                class_437 class_4372 = class_310.method_1551().field_1755;
                if (class_4372 instanceof ReatomizerModScreens.FabricScreenAccessor) {
                    ReatomizerModScreens.FabricScreenAccessor accessor = (ReatomizerModScreens.FabricScreenAccessor)class_4372;
                    if (needClientUpdate) {
                        accessor.updateMenuState(elementType, name, elementState);
                    }
                }
                buf = PacketByteBufs.create();
                MenuStateUpdateMessage.write(buf, new MenuStateUpdateMessage(elementType, name, elementState, cx, cy, cz, correlationId));
                ClientPlayNetworking.send((class_2960)MenuStateUpdateMessage.ID, (class_2540)buf);
            }
        }

        default public <T> T getMenuState(int elementType, String name, T defaultValue) {
            try {
                return (T)this.getMenuState().getOrDefault(elementType + ":" + name, defaultValue);
            }
            catch (ClassCastException e) {
                return defaultValue;
            }
        }
    }
}

