/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.reatomizer.util;

import java.lang.reflect.Method;
import net.mcreator.reatomizer.recipe.BlueprintRecipe;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RecipeDiagnostics {
    private static final Logger LOGGER = LogManager.getLogger(RecipeDiagnostics.class);
    public static volatile boolean loggedOnce = false;

    public static void log(MinecraftServer server) {
        try {
            class_1863 rm = server.method_3772();
            LOGGER.info("[Reatomizer] RecipeManager recipe count (estimated): {}", (Object)rm.method_8126().size());
            int found = 0;
            for (Object entry : rm.method_8126()) {
                try {
                    class_1860 r = null;
                    if (entry instanceof class_1860) {
                        r = (class_1860)entry;
                    } else {
                        try {
                            Method valMethod = entry.getClass().getMethod("value", new Class[0]);
                            Object val = valMethod.invoke(entry, new Object[0]);
                            if (val instanceof class_1860) {
                                r = (class_1860)val;
                            }
                        }
                        catch (NoSuchMethodException valMethod) {
                            // empty catch block
                        }
                    }
                    if (!(r instanceof BlueprintRecipe)) continue;
                    try {
                        try {
                            Method getIdMethod = r.getClass().getMethod("getId", new Class[0]);
                            Object rid = getIdMethod.invoke((Object)r, new Object[0]);
                            LOGGER.info("[Reatomizer] Found BlueprintRecipe id={}", rid);
                        }
                        catch (NoSuchMethodException nsme) {
                            LOGGER.info("[Reatomizer] Found BlueprintRecipe (id unavailable) entry={}", (Object)entry.toString());
                        }
                    }
                    catch (Throwable t) {
                        LOGGER.info("[Reatomizer] Found BlueprintRecipe (id unavailable) entry={}", (Object)entry.toString());
                    }
                    ++found;
                }
                catch (Throwable throwable) {}
            }
            LOGGER.info("[Reatomizer] BlueprintRecipe instances found: {}", (Object)found);
        }
        catch (Throwable t) {
            LOGGER.warn("[Reatomizer] RecipeDiagnostics error", t);
        }
    }
}

