/*
 * Decompiled with CFR 0.152.
 */
package com.blogspot.michaelsebero.movinglightsource;

import com.blogspot.michaelsebero.movinglightsource.MainMod;
import com.blogspot.michaelsebero.movinglightsource.blocks.BlockMovingLightSource;
import com.blogspot.michaelsebero.movinglightsource.registries.BlockRegistry;
import com.blogspot.michaelsebero.movinglightsource.tileentities.TileEntityMovingLightSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class EventHandler {
    private static final Map<Integer, BlockPos> lastItemLightBlockPos = new HashMap<Integer, BlockPos>();
    private static final Map<Integer, Block> lastItemLightBlockType = new HashMap<Integer, Block>();
    private static final Map<BlockPos, Integer> itemLightBlockOwnership = new HashMap<BlockPos, Integer>();
    private static final Map<Integer, BlockPos> lastProjectileLightBlockPos = new HashMap<Integer, BlockPos>();
    private static final Map<BlockPos, Integer> projectileLightBlockOwnership = new HashMap<BlockPos, Integer>();
    private static final int ITEM_LIGHT_UPDATE_INTERVAL = 2;
    private static final int PROJECTILE_LIGHT_UPDATE_INTERVAL = 1;

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(RegistryEvent.NewRegistry event) {
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(LivingEvent.LivingUpdateEvent event) {
        Block lightBlock;
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity.func_70027_ad() && MainMod.allowBurningEntitiesToGiveOffLight) {
            this.placeLightBlockForLivingEntity(entity, BlockRegistry.MOVING_LIGHT_SOURCE_15);
        } else if (!(entity instanceof EntityPlayer) && BlockMovingLightSource.isHoldingLightItem(entity) && MainMod.allowHeldItemsToGiveOffLight && (lightBlock = BlockMovingLightSource.lightBlockToPlace(entity)) != Blocks.field_150350_a) {
            this.placeLightBlockForLivingEntity(entity, lightBlock);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(TickEvent.WorldTickEvent event) {
        ArrayList entityListCopy;
        if (event.phase != TickEvent.Phase.END || event.world.field_72995_K) {
            return;
        }
        try {
            entityListCopy = new ArrayList(event.world.field_72996_f);
        }
        catch (Exception e) {
            return;
        }
        if (MainMod.allowEntityItemsToGiveOffLight && event.world.func_82737_E() % 2L == 0L) {
            HashMap<Integer, Boolean> seenItems = new HashMap<Integer, Boolean>();
            for (Entity entity : entityListCopy) {
                if (!(entity instanceof EntityItem)) continue;
                EntityItem entityItem = (EntityItem)entity;
                seenItems.put(entityItem.func_145782_y(), true);
                this.handleEntityItemLight(entityItem);
            }
            this.cleanupOrphanedItemLights(event.world, seenItems);
        }
        if (MainMod.allowBurningEntitiesToGiveOffLight && event.world.func_82737_E() % 1L == 0L) {
            HashMap<Integer, Boolean> seenProjectiles = new HashMap<Integer, Boolean>();
            for (Entity entity : entityListCopy) {
                if (entity instanceof EntityLivingBase || entity instanceof EntityItem || !entity.func_70027_ad()) continue;
                seenProjectiles.put(entity.func_145782_y(), true);
                this.handleBurningProjectileLight(entity);
            }
            this.cleanupOrphanedProjectileLights(event.world, seenProjectiles);
        }
    }

    private void cleanupOrphanedItemLights(World world, Map<Integer, Boolean> seenItems) {
        Iterator<Map.Entry<Integer, BlockPos>> iterator = lastItemLightBlockPos.entrySet().iterator();
        while (iterator.hasNext()) {
            Integer owner;
            Block block;
            Map.Entry<Integer, BlockPos> entry = iterator.next();
            int entityId = entry.getKey();
            if (seenItems.containsKey(entityId)) continue;
            BlockPos pos = entry.getValue();
            if (pos != null && (block = world.func_180495_p(pos).func_177230_c()) instanceof BlockMovingLightSource && (owner = itemLightBlockOwnership.get(pos)) != null && owner == entityId) {
                TileEntity te = world.func_175625_s(pos);
                if (te instanceof TileEntityMovingLightSource) {
                    ((TileEntityMovingLightSource)te).markAsItemLight();
                }
                world.func_175698_g(pos);
                itemLightBlockOwnership.remove(pos);
            }
            iterator.remove();
            lastItemLightBlockType.remove(entityId);
        }
    }

    private void cleanupOrphanedProjectileLights(World world, Map<Integer, Boolean> seenProjectiles) {
        Iterator<Map.Entry<Integer, BlockPos>> iterator = lastProjectileLightBlockPos.entrySet().iterator();
        while (iterator.hasNext()) {
            Integer owner;
            Block block;
            Map.Entry<Integer, BlockPos> entry = iterator.next();
            int entityId = entry.getKey();
            if (seenProjectiles.containsKey(entityId)) continue;
            BlockPos pos = entry.getValue();
            if (pos != null && (block = world.func_180495_p(pos).func_177230_c()) instanceof BlockMovingLightSource && (owner = projectileLightBlockOwnership.get(pos)) != null && owner == entityId) {
                world.func_175698_g(pos);
                projectileLightBlockOwnership.remove(pos);
            }
            iterator.remove();
        }
    }

    private void handleEntityItemLight(EntityItem entityItem) {
        if (entityItem == null || entityItem.field_70128_L) {
            return;
        }
        ItemStack stack = entityItem.func_92059_d();
        int lightLevel = BlockMovingLightSource.getItemLightLevel(stack);
        if (lightLevel > 0) {
            Block lightBlock = BlockMovingLightSource.getLightBlockForLevel(lightLevel);
            if (lightBlock != null && lightBlock != Blocks.field_150350_a) {
                this.placeItemLight(entityItem, lightBlock);
            }
        } else {
            this.removeItemLight(entityItem);
        }
    }

    private void handleBurningProjectileLight(Entity projectile) {
        if (projectile == null || projectile.field_70128_L || !projectile.func_70027_ad()) {
            this.removeProjectileLight(projectile);
            return;
        }
        this.placeProjectileLight(projectile, BlockRegistry.MOVING_LIGHT_SOURCE_15);
    }

    private void placeProjectileLight(Entity projectile, Block lightBlock) {
        Block blockAtLocation;
        int entityId = projectile.func_145782_y();
        World world = projectile.field_70170_p;
        int blockX = MathHelper.func_76128_c((double)projectile.field_70165_t);
        int blockY = MathHelper.func_76128_c((double)projectile.field_70163_u);
        int blockZ = MathHelper.func_76128_c((double)projectile.field_70161_v);
        BlockPos[] positionsToTry = new BlockPos[]{new BlockPos(blockX, blockY, blockZ), new BlockPos(blockX, blockY + 1, blockZ)};
        BlockPos lastPos = lastProjectileLightBlockPos.get(entityId);
        BlockPos targetPos = null;
        for (BlockPos pos : positionsToTry) {
            Block blockAtLocation2 = world.func_180495_p(pos).func_177230_c();
            if (blockAtLocation2 != Blocks.field_150350_a && !(blockAtLocation2 instanceof BlockMovingLightSource)) continue;
            targetPos = pos;
            break;
        }
        if (targetPos == null) {
            return;
        }
        if (lastPos != null && !lastPos.equals(targetPos)) {
            this.removeProjectileLightAtPos(world, lastPos, entityId);
        }
        if ((blockAtLocation = world.func_180495_p(targetPos).func_177230_c()) == Blocks.field_150350_a) {
            world.func_180501_a(targetPos, lightBlock.func_176223_P(), 3);
            lastProjectileLightBlockPos.put(entityId, targetPos);
            projectileLightBlockOwnership.put(targetPos, entityId);
        } else if (blockAtLocation instanceof BlockMovingLightSource) {
            lastProjectileLightBlockPos.put(entityId, targetPos);
            projectileLightBlockOwnership.put(targetPos, entityId);
        }
    }

    private void removeProjectileLight(Entity projectile) {
        if (projectile == null) {
            return;
        }
        int entityId = projectile.func_145782_y();
        BlockPos lastPos = lastProjectileLightBlockPos.get(entityId);
        if (lastPos != null) {
            this.removeProjectileLightAtPos(projectile.field_70170_p, lastPos, entityId);
            lastProjectileLightBlockPos.remove(entityId);
        }
    }

    private void removeProjectileLightAtPos(World world, BlockPos pos, int entityId) {
        Integer owner;
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof BlockMovingLightSource && ((owner = projectileLightBlockOwnership.get(pos)) == null || owner == entityId)) {
            world.func_175698_g(pos);
            projectileLightBlockOwnership.remove(pos);
        }
    }

    private void placeItemLight(EntityItem entityItem, Block lightBlock) {
        Block blockAtLocation;
        int entityId = entityItem.func_145782_y();
        World world = entityItem.field_70170_p;
        int blockX = MathHelper.func_76128_c((double)entityItem.field_70165_t);
        int blockY = MathHelper.func_76128_c((double)entityItem.field_70163_u);
        int blockZ = MathHelper.func_76128_c((double)entityItem.field_70161_v);
        BlockPos[] positionsToTry = new BlockPos[]{new BlockPos(blockX, blockY, blockZ), new BlockPos(blockX, blockY + 1, blockZ)};
        BlockPos lastPos = lastItemLightBlockPos.get(entityId);
        Block lastBlock = lastItemLightBlockType.get(entityId);
        BlockPos targetPos = null;
        for (BlockPos pos : positionsToTry) {
            Block blockAtLocation2 = world.func_180495_p(pos).func_177230_c();
            if (blockAtLocation2 != Blocks.field_150350_a && !(blockAtLocation2 instanceof BlockMovingLightSource)) continue;
            targetPos = pos;
            break;
        }
        if (targetPos == null) {
            return;
        }
        if (targetPos.equals((Object)lastPos) && lightBlock == lastBlock) {
            TileEntity te = world.func_175625_s(targetPos);
            if (te instanceof TileEntityMovingLightSource) {
                ((TileEntityMovingLightSource)te).setTrackedItem(entityItem);
            }
            return;
        }
        if (lastPos != null && !lastPos.equals(targetPos)) {
            this.removeItemLightAtPos(world, lastPos, entityId);
        }
        if ((blockAtLocation = world.func_180495_p(targetPos).func_177230_c()) == Blocks.field_150350_a) {
            world.func_175656_a(targetPos, lightBlock.func_176223_P());
            TileEntity te = world.func_175625_s(targetPos);
            if (te instanceof TileEntityMovingLightSource) {
                ((TileEntityMovingLightSource)te).setTrackedItem(entityItem);
            }
            this.updateItemCache(entityId, targetPos, lightBlock);
            itemLightBlockOwnership.put(targetPos, entityId);
        } else if (blockAtLocation instanceof BlockMovingLightSource) {
            Integer owner = itemLightBlockOwnership.get(targetPos);
            float currentLight = blockAtLocation.func_149750_m(blockAtLocation.func_176223_P());
            float desiredLight = lightBlock.func_149750_m(lightBlock.func_176223_P());
            if (owner == null || owner == entityId) {
                TileEntity te;
                if (Math.abs(currentLight - desiredLight) > 0.001f) {
                    world.func_175656_a(targetPos, lightBlock.func_176223_P());
                }
                if ((te = world.func_175625_s(targetPos)) instanceof TileEntityMovingLightSource) {
                    ((TileEntityMovingLightSource)te).setTrackedItem(entityItem);
                }
                this.updateItemCache(entityId, targetPos, lightBlock);
                itemLightBlockOwnership.put(targetPos, entityId);
            }
        }
    }

    private void removeItemLight(EntityItem entityItem) {
        int entityId = entityItem.func_145782_y();
        BlockPos lastPos = lastItemLightBlockPos.get(entityId);
        if (lastPos != null) {
            this.removeItemLightAtPos(entityItem.field_70170_p, lastPos, entityId);
            this.clearItemCache(entityId);
        }
    }

    private void removeItemLightAtPos(World world, BlockPos pos, int entityId) {
        Integer owner;
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof BlockMovingLightSource && ((owner = itemLightBlockOwnership.get(pos)) == null || owner == entityId)) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileEntityMovingLightSource) {
                ((TileEntityMovingLightSource)te).markAsItemLight();
            }
            world.func_175698_g(pos);
            itemLightBlockOwnership.remove(pos);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && !event.player.field_70170_p.field_72995_K) {
            this.handlePlayerLightPlacement(event.player);
        }
    }

    private void handlePlayerLightPlacement(EntityPlayer player) {
        float desiredLight;
        float currentLight;
        if (!BlockMovingLightSource.isHoldingLightItem((EntityLivingBase)player) || !MainMod.allowHeldItemsToGiveOffLight) {
            return;
        }
        int blockX = MathHelper.func_76128_c((double)player.field_70165_t);
        int blockY = MathHelper.func_76128_c((double)(player.field_70163_u - 0.2 - player.func_70033_W()));
        int blockZ = MathHelper.func_76128_c((double)player.field_70161_v);
        BlockPos targetPos = new BlockPos(blockX, blockY, blockZ).func_177984_a();
        Block desiredLightBlock = BlockMovingLightSource.lightBlockToPlace((EntityLivingBase)player);
        Block blockAtLocation = player.field_70170_p.func_180495_p(targetPos).func_177230_c();
        if (blockAtLocation == Blocks.field_150350_a) {
            player.field_70170_p.func_175656_a(targetPos, desiredLightBlock.func_176223_P());
        } else if (blockAtLocation instanceof BlockMovingLightSource && Math.abs((currentLight = (float)blockAtLocation.func_149750_m(blockAtLocation.func_176223_P())) - (desiredLight = (float)desiredLightBlock.func_149750_m(desiredLightBlock.func_176223_P()))) > 0.001f) {
            player.field_70170_p.func_175656_a(targetPos, desiredLightBlock.func_176223_P());
        }
    }

    private void placeLightBlockForLivingEntity(EntityLivingBase entity, Block lightBlock) {
        float desiredLight;
        float currentLight;
        int blockZ;
        int blockY;
        if (entity == null || lightBlock == null) {
            return;
        }
        int blockX = MathHelper.func_76128_c((double)entity.field_70165_t);
        BlockPos targetPos = new BlockPos(blockX, blockY = MathHelper.func_76128_c((double)(entity.field_70163_u - 0.2)), blockZ = MathHelper.func_76128_c((double)entity.field_70161_v)).func_177984_a();
        Block blockAtLocation = entity.field_70170_p.func_180495_p(targetPos).func_177230_c();
        if (blockAtLocation == Blocks.field_150350_a) {
            entity.field_70170_p.func_175656_a(targetPos, lightBlock.func_176223_P());
        } else if (blockAtLocation instanceof BlockMovingLightSource && Math.abs((currentLight = (float)blockAtLocation.func_149750_m(blockAtLocation.func_176223_P())) - (desiredLight = (float)lightBlock.func_149750_m(lightBlock.func_176223_P()))) > 0.001f) {
            entity.field_70170_p.func_175656_a(targetPos, lightBlock.func_176223_P());
        }
    }

    private void updateItemCache(int entityId, BlockPos pos, Block block) {
        lastItemLightBlockPos.put(entityId, pos);
        lastItemLightBlockType.put(entityId, block);
    }

    private void clearItemCache(int entityId) {
        Integer owner;
        BlockPos oldPos = lastItemLightBlockPos.remove(entityId);
        lastItemLightBlockType.remove(entityId);
        if (oldPos != null && (owner = itemLightBlockOwnership.get(oldPos)) != null && owner == entityId) {
            itemLightBlockOwnership.remove(oldPos);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(AttackEntityEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (player.func_184614_ca().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa) && MainMod.allowTorchesToBurnEntities && event.getTarget() != null) {
            event.getTarget().func_70015_d(10);
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL, receiveCanceled=true)
    public void onEvent(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if (eventArgs.getModID().equals("movinglightsource")) {
            System.out.println("Config changed for mod: " + eventArgs.getModID());
            MainMod.config.save();
            MainMod.proxy.syncConfig();
            lastItemLightBlockPos.clear();
            lastItemLightBlockType.clear();
            itemLightBlockOwnership.clear();
            lastProjectileLightBlockPos.clear();
            projectileLightBlockOwnership.clear();
            BlockMovingLightSource.clearCache();
        }
    }
}

