/*
 * Decompiled with CFR 0.152.
 */
package com.blogspot.michaelsebero.movinglightsource.proxy;

import com.blogspot.michaelsebero.movinglightsource.EventHandler;
import com.blogspot.michaelsebero.movinglightsource.MainMod;
import com.blogspot.michaelsebero.movinglightsource.OreGenEventHandler;
import com.blogspot.michaelsebero.movinglightsource.TerrainGenEventHandler;
import com.blogspot.michaelsebero.movinglightsource.gui.GuiHandler;
import com.blogspot.michaelsebero.movinglightsource.networking.MessageExtendedReachAttack;
import com.blogspot.michaelsebero.movinglightsource.networking.MessageRequestItemStackRegistryFromClient;
import com.blogspot.michaelsebero.movinglightsource.networking.MessageSendItemStackRegistryToServer;
import com.blogspot.michaelsebero.movinglightsource.networking.MessageSyncEntityToClient;
import com.blogspot.michaelsebero.movinglightsource.networking.MessageToClient;
import com.blogspot.michaelsebero.movinglightsource.networking.MessageToServer;
import com.blogspot.michaelsebero.movinglightsource.tileentities.TileEntityMovingLightSource;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.common.event.FMLServerStartedEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class CommonProxy {
    protected int modEntityID = 0;
    protected List<ItemStack> itemStackRegistry = new ArrayList<ItemStack>();

    public void fmlLifeCycleEvent(FMLPreInitializationEvent event) {
        this.initConfig(event);
        this.registerTileEntities();
        this.registerModEntities();
        this.registerEntitySpawns();
        this.registerFuelHandlers();
        this.registerSimpleNetworking();
    }

    public void fmlLifeCycleEvent(FMLInitializationEvent event) {
        this.registerEventListeners();
        this.registerRecipes();
        this.registerAdvancements();
        this.registerGuiHandlers();
    }

    public void registerGuiHandlers() {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)MainMod.instance, (IGuiHandler)new GuiHandler());
    }

    public void fmlLifeCycleEvent(FMLPostInitializationEvent event) {
        this.initItemStackRegistry();
    }

    public void fmlLifeCycleEvent(FMLServerAboutToStartEvent event) {
    }

    public void fmlLifeCycleEvent(FMLServerStartedEvent event) {
    }

    public void fmlLifeCycleEvent(FMLServerStoppingEvent event) {
    }

    public void fmlLifeCycleEvent(FMLServerStoppedEvent event) {
    }

    public void fmlLifeCycleEvent(FMLServerStartingEvent event) {
    }

    protected void registerSimpleNetworking() {
        System.out.println("Registering simple networking");
        MainMod.network = NetworkRegistry.INSTANCE.newSimpleChannel("movinglightsource");
        int packetId = 0;
        MainMod.network.registerMessage(MessageToServer.Handler.class, MessageToServer.class, packetId++, Side.SERVER);
        MainMod.network.registerMessage(MessageToClient.Handler.class, MessageToClient.class, packetId++, Side.CLIENT);
        MainMod.network.registerMessage(MessageSyncEntityToClient.Handler.class, MessageSyncEntityToClient.class, packetId++, Side.CLIENT);
        MainMod.network.registerMessage(MessageExtendedReachAttack.Handler.class, MessageExtendedReachAttack.class, packetId++, Side.SERVER);
        MainMod.network.registerMessage(MessageSendItemStackRegistryToServer.Handler.class, MessageSendItemStackRegistryToServer.class, packetId++, Side.SERVER);
        MainMod.network.registerMessage(MessageRequestItemStackRegistryFromClient.Handler.class, MessageRequestItemStackRegistryFromClient.class, packetId++, Side.CLIENT);
    }

    public EntityPlayer getPlayerEntityFromContext(MessageContext ctx) {
        return ctx.getServerHandler().field_147369_b;
    }

    protected void initConfig(FMLPreInitializationEvent event) {
        MainMod.configFile = event.getSuggestedConfigurationFile();
        System.out.println("Torches and Moving Light Sources config path = " + MainMod.configFile.getAbsolutePath());
        System.out.println("Config file exists = " + MainMod.configFile.canRead());
        MainMod.config = new Configuration(MainMod.configFile);
        this.syncConfig();
    }

    public void syncConfig() {
        MainMod.config.load();
        MainMod.allowHeldItemsToGiveOffLight = MainMod.config.get("general", "Held items can give off light", true, "Holding certain items like torches and glowstone will give off light.").getBoolean(true);
        System.out.println("Allow held items to give off light = " + MainMod.allowHeldItemsToGiveOffLight);
        MainMod.allowTorchesToBurnEntities = MainMod.config.get("general", "Torches can burn entities", true, "Attacking with regular torch will set entities on fire.").getBoolean(true);
        System.out.println("Allow torches to burn entities = " + MainMod.allowTorchesToBurnEntities);
        MainMod.allowBurningEntitiesToGiveOffLight = MainMod.config.get("general", "Burning entities give off light", true, "When an entity is burning it gives off same light as a fire block.").getBoolean(true);
        System.out.println("Burning entities give off light = " + MainMod.allowBurningEntitiesToGiveOffLight);
        MainMod.config.save();
    }

    public void registerFluids() {
    }

    public void registerTileEntities() {
        System.out.println("Registering tile entities");
        GameRegistry.registerTileEntity(TileEntityMovingLightSource.class, (String)"tileEntityMovingLightSource");
    }

    public void registerRecipes() {
    }

    protected void registerModEntities() {
        System.out.println("Registering entities");
    }

    protected void registerModEntity(Class<? extends Entity> entityClass, String entityName) {
        ResourceLocation resourceLocation = new ResourceLocation("movinglightsource", entityName);
        EntityRegistry.registerModEntity((ResourceLocation)resourceLocation, entityClass, (String)entityName, (int)(++this.modEntityID), (Object)MainMod.instance, (int)80, (int)3, (boolean)false);
    }

    protected void registerModEntityFastTracking(Class<? extends Entity> entityClass, String entityName) {
        ResourceLocation resourceLocation = new ResourceLocation("movinglightsource", entityName);
        EntityRegistry.registerModEntity((ResourceLocation)resourceLocation, entityClass, (String)entityName, (int)(++this.modEntityID), (Object)MainMod.instance, (int)80, (int)10, (boolean)true);
    }

    public void registerModEntityWithEgg(Class<? extends Entity> entityClass, String entityName, int eggColor, int eggSpotsColor) {
        ResourceLocation resourceLocation = new ResourceLocation("movinglightsource", entityName);
        EntityRegistry.registerModEntity((ResourceLocation)resourceLocation, entityClass, (String)entityName, (int)(++this.modEntityID), (Object)MainMod.instance, (int)80, (int)3, (boolean)false, (int)eggColor, (int)eggSpotsColor);
    }

    protected void registerEntitySpawns() {
        System.out.println("Registering natural spawns");
    }

    protected void addSpawnAllBiomes(EntityLiving entity, int chance, int minGroup, int maxGroup) {
        Iterator allBiomesIterator = Biome.field_185377_q.func_148742_b().iterator();
        while (allBiomesIterator.hasNext()) {
            Biome nextBiome = (Biome)Biome.field_185377_q.func_82594_a(allBiomesIterator.next());
            EntityRegistry.addSpawn(entity.getClass(), (int)chance, (int)minGroup, (int)maxGroup, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])new Biome[]{nextBiome});
        }
    }

    protected void registerFuelHandlers() {
        System.out.println("Registering fuel handlers");
    }

    protected void registerEventListeners() {
        System.out.println("Registering event listeners");
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new TerrainGenEventHandler());
        MinecraftForge.ORE_GEN_BUS.register((Object)new OreGenEventHandler());
    }

    protected void registerAdvancements() {
    }

    protected void initItemStackRegistry() {
    }

    public void setItemStackRegistry(List<ItemStack> registry) {
        this.itemStackRegistry = registry;
    }

    public List<ItemStack> getItemStackRegistry() {
        return this.itemStackRegistry;
    }

    public void convertItemStackListToPayload(ByteBuf buffer) {
        Iterator<ItemStack> iterator = this.itemStackRegistry.iterator();
        while (iterator.hasNext()) {
            NBTTagCompound nbt;
            ItemStack stack = iterator.next();
            buffer.writeInt(Item.func_150891_b((Item)stack.func_77973_b()));
            buffer.writeInt(stack.func_77960_j());
            boolean hasNBT = stack.func_77942_o();
            buffer.writeBoolean(hasNBT);
            if (hasNBT && (nbt = stack.func_77978_p()) != null) {
                ByteBufUtils.writeTag((ByteBuf)buffer, (NBTTagCompound)nbt);
            }
            iterator.remove();
        }
    }

    public List<ItemStack> convertPayloadToItemStackList(ByteBuf buffer) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        while (buffer.isReadable()) {
            NBTTagCompound nbt;
            int itemId = buffer.readInt();
            int metadata = buffer.readInt();
            ItemStack stack = new ItemStack(Item.func_150899_d((int)itemId), 1, metadata);
            boolean hasNBT = buffer.readBoolean();
            if (hasNBT && (nbt = ByteBufUtils.readTag((ByteBuf)buffer)) != null) {
                stack.func_77982_d(nbt);
            }
            list.add(stack);
        }
        return list;
    }
}

