/*
 * Decompiled with CFR 0.152.
 */
package com.blogspot.michaelsebero.movinglightsource.tileentities;

import com.blogspot.michaelsebero.movinglightsource.blocks.BlockMovingLightSource;
import com.blogspot.michaelsebero.movinglightsource.utilities.Utilities;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class TileEntityMovingLightSource
extends TileEntity
implements ITickable {
    private EntityLivingBase theEntityLiving;
    private EntityItem trackedItem;
    private boolean isItemLight = false;
    private boolean shouldDie = false;
    private int deathTimer = 1;
    private int tickCounter = 0;
    private static final int UPDATE_FREQUENCY = 3;
    private static final double MAX_DISTANCE_SQ = 5.0;
    private static final double ITEM_MAX_DISTANCE_SQ = 3.0;

    public void func_73660_a() {
        ++this.tickCounter;
        if (this.tickCounter < 3 && !this.shouldDie) {
            return;
        }
        this.tickCounter = 0;
        if (this.shouldDie) {
            if (this.deathTimer > 0) {
                --this.deathTimer;
                return;
            }
            if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175698_g(this.func_174877_v());
            }
            return;
        }
        if (this.field_145850_b == null) {
            return;
        }
        if (this.isItemLight || this.trackedItem != null) {
            this.updateItemLight();
            return;
        }
        this.updateLivingEntityLight();
    }

    private void updateItemLight() {
        Block blockAtLocation;
        double distanceSquared;
        if (this.trackedItem == null || this.trackedItem.field_70128_L) {
            this.trackedItem = this.findNearbyLightItem();
            if (this.trackedItem == null) {
                Block blockAtLocation2 = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c();
                if (blockAtLocation2 instanceof BlockMovingLightSource) {
                    this.shouldDie = true;
                    this.deathTimer = 0;
                }
                return;
            }
        }
        if ((distanceSquared = this.getDistanceSqToEntity((Entity)this.trackedItem)) > 3.0) {
            Block blockAtLocation3 = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c();
            if (blockAtLocation3 instanceof BlockMovingLightSource) {
                this.shouldDie = true;
                this.deathTimer = 0;
            }
            return;
        }
        if ((this.trackedItem.func_92059_d().func_190926_b() || !this.isItemEmittingLight(this.trackedItem)) && (blockAtLocation = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c()) instanceof BlockMovingLightSource) {
            this.shouldDie = true;
            this.deathTimer = 0;
        }
    }

    private boolean isItemEmittingLight(EntityItem entityItem) {
        if (entityItem == null || entityItem.func_92059_d().func_190926_b()) {
            return false;
        }
        return BlockMovingLightSource.LIGHT_SOURCE_MAP.containsKey(entityItem.func_92059_d().func_77973_b()) || this.getLightLevelForItem(entityItem.func_92059_d().func_77973_b()) > 0;
    }

    private int getLightLevelForItem(Item item) {
        ItemBlock itemBlock;
        Block block;
        if (item instanceof ItemBlock && (block = (itemBlock = (ItemBlock)item).func_179223_d()) != null && block != Blocks.field_150350_a) {
            return block.func_149750_m(block.func_176223_P());
        }
        return 0;
    }

    private void updateLivingEntityLight() {
        Block blockAtLocation = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c();
        if (this.theEntityLiving == null) {
            if (blockAtLocation instanceof BlockMovingLightSource) {
                this.shouldDie = true;
            }
            return;
        }
        if (this.theEntityLiving.field_70128_L) {
            if (blockAtLocation instanceof BlockMovingLightSource) {
                this.shouldDie = true;
            }
            return;
        }
        double distanceSquared = this.getDistanceSqToEntity((Entity)this.theEntityLiving);
        if (distanceSquared > 5.0) {
            if (blockAtLocation instanceof BlockMovingLightSource) {
                this.shouldDie = true;
            }
            return;
        }
        if (!this.theEntityLiving.func_70027_ad()) {
            if (!BlockMovingLightSource.isHoldingLightItem(this.theEntityLiving)) {
                if (blockAtLocation instanceof BlockMovingLightSource) {
                    this.shouldDie = true;
                }
            } else {
                Block expectedBlock = BlockMovingLightSource.lightBlockToPlace(this.theEntityLiving);
                if (blockAtLocation != expectedBlock) {
                    this.shouldDie = true;
                }
            }
        }
    }

    private EntityItem findNearbyLightItem() {
        if (this.field_145850_b == null) {
            return null;
        }
        AxisAlignedBB searchBox = new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 2), (double)(this.field_174879_c.func_177956_o() - 2), (double)(this.field_174879_c.func_177952_p() - 2), (double)(this.field_174879_c.func_177958_n() + 3), (double)(this.field_174879_c.func_177956_o() + 3), (double)(this.field_174879_c.func_177952_p() + 3));
        List items = this.field_145850_b.func_72872_a(EntityItem.class, searchBox);
        for (EntityItem item : items) {
            double distSq;
            if (item.field_70128_L || item.func_92059_d().func_190926_b() || !this.isItemEmittingLight(item) || !((distSq = this.getDistanceSqToEntity((Entity)item)) <= 3.0)) continue;
            return item;
        }
        return null;
    }

    private double getDistanceSqToEntity(Entity entity) {
        double dx = entity.field_70165_t - ((double)this.field_174879_c.func_177958_n() + 0.5);
        double dy = entity.field_70163_u - (double)this.field_174879_c.func_177956_o();
        double dz = entity.field_70161_v - ((double)this.field_174879_c.func_177952_p() + 0.5);
        return dx * dx + dy * dy + dz * dz;
    }

    public void setEntityLiving(EntityLivingBase parEntityLiving) {
        this.theEntityLiving = parEntityLiving;
        this.isItemLight = false;
        this.trackedItem = null;
    }

    public EntityLivingBase getEntityLiving() {
        return this.theEntityLiving;
    }

    public void setTrackedItem(EntityItem item) {
        this.trackedItem = item;
        this.isItemLight = true;
        this.theEntityLiving = null;
    }

    public void markAsItemLight() {
        this.isItemLight = true;
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        if (this.field_145850_b != null) {
            EntityItem nearbyItem;
            this.setEntityLiving(Utilities.getClosestEntityLiving(this.field_145850_b, this.field_174879_c, 2.0));
            if (this.theEntityLiving == null && (nearbyItem = this.findNearbyLightItem()) != null) {
                this.setTrackedItem(nearbyItem);
            }
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.theEntityLiving = null;
        this.trackedItem = null;
    }
}

