/*
 * Decompiled with CFR 0.152.
 */
package com.blogspot.michaelsebero.movinglightsource.blocks;

import com.blogspot.michaelsebero.movinglightsource.registries.BlockRegistry;
import com.blogspot.michaelsebero.movinglightsource.tileentities.TileEntityMovingLightSource;
import com.blogspot.michaelsebero.movinglightsource.utilities.Utilities;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMovingLightSource
extends Block
implements ITileEntityProvider {
    public static final HashMap<Item, Block> LIGHT_SOURCE_MAP = new HashMap();
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.5, 0.5, 0.5, 0.5, 0.5, 0.5);

    public BlockMovingLightSource(String parName) {
        super(Material.field_151579_a);
        Utilities.setBlockName(this, parName);
        this.func_180632_j(this.field_176227_L.func_177621_b());
        this.func_149675_a(false);
        this.func_149715_a(1.0f);
    }

    public static void initMapLightSources() {
        LIGHT_SOURCE_MAP.clear();
        BlockMovingLightSource.addLightSource(Item.func_150898_a((Block)Blocks.field_150461_bJ), BlockRegistry.MOVING_LIGHT_SOURCE_15);
        BlockMovingLightSource.addLightSource(Item.func_150898_a((Block)Blocks.field_150428_aP), BlockRegistry.MOVING_LIGHT_SOURCE_15);
        BlockMovingLightSource.addLightSource(Items.field_151129_at, BlockRegistry.MOVING_LIGHT_SOURCE_15);
        BlockMovingLightSource.addLightSource(Item.func_150898_a((Block)Blocks.field_150426_aN), BlockRegistry.MOVING_LIGHT_SOURCE_15);
        BlockMovingLightSource.addLightSource(Items.field_151114_aO, BlockRegistry.MOVING_LIGHT_SOURCE_15);
        BlockMovingLightSource.addLightSource(Item.func_150898_a((Block)Blocks.field_180398_cJ), BlockRegistry.MOVING_LIGHT_SOURCE_15);
        BlockMovingLightSource.addLightSource(Item.func_150898_a((Block)Blocks.field_185764_cQ), BlockRegistry.MOVING_LIGHT_SOURCE_14);
        BlockMovingLightSource.addLightSource(Item.func_150898_a((Block)Blocks.field_150478_aa), BlockRegistry.MOVING_LIGHT_SOURCE_14);
        BlockMovingLightSource.addLightSource(Item.func_150898_a((Block)Blocks.field_150429_aA), BlockRegistry.MOVING_LIGHT_SOURCE_9);
        BlockMovingLightSource.addLightSource(Item.func_150898_a((Block)Blocks.field_150450_ax), BlockRegistry.MOVING_LIGHT_SOURCE_7);
        LIGHT_SOURCE_MAP.remove(Items.field_190931_a);
        System.out.println("[MovingLightSource] Registered " + LIGHT_SOURCE_MAP.size() + " vanilla light-emitting items");
        System.out.println("[MovingLightSource] Dynamic detection enabled for modded light sources");
    }

    private static void addLightSource(Item item, Block block) {
        if (item != null && item != Items.field_190931_a && block != null) {
            LIGHT_SOURCE_MAP.put(item, block);
        }
    }

    public BlockMovingLightSource(String parName, float parLightLevel) {
        this(parName);
        this.func_149715_a(parLightLevel);
    }

    public static int getItemLightLevel(ItemStack stack) {
        int lightLevel;
        ItemBlock itemBlock;
        Block block;
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && (block = (itemBlock = (ItemBlock)item).func_179223_d()) != null && block != Blocks.field_150350_a && (lightLevel = block.func_149750_m(block.func_176223_P())) > 0) {
            return lightLevel;
        }
        Block staticBlock = LIGHT_SOURCE_MAP.get(item);
        if (staticBlock != null) {
            return staticBlock.func_149750_m(staticBlock.func_176223_P());
        }
        return 0;
    }

    public static Block getLightBlockForLevel(int lightLevel) {
        if (lightLevel >= 15) {
            return BlockRegistry.MOVING_LIGHT_SOURCE_15;
        }
        if (lightLevel >= 14) {
            return BlockRegistry.MOVING_LIGHT_SOURCE_14;
        }
        if (lightLevel >= 9) {
            return BlockRegistry.MOVING_LIGHT_SOURCE_9;
        }
        if (lightLevel >= 7) {
            return BlockRegistry.MOVING_LIGHT_SOURCE_7;
        }
        if (lightLevel > 0) {
            return BlockRegistry.MOVING_LIGHT_SOURCE_7;
        }
        return Blocks.field_150350_a;
    }

    public static boolean isHoldingLightItem(EntityLivingBase entity) {
        if (entity == null) {
            return false;
        }
        ItemStack mainHand = entity.func_184614_ca();
        ItemStack offHand = entity.func_184592_cb();
        return BlockMovingLightSource.getItemLightLevel(mainHand) > 0 || BlockMovingLightSource.getItemLightLevel(offHand) > 0;
    }

    public static Block lightBlockToPlace(EntityLivingBase entity) {
        if (entity == null) {
            return Blocks.field_150350_a;
        }
        ItemStack mainHand = entity.func_184614_ca();
        ItemStack offHand = entity.func_184592_cb();
        int mainHandLight = BlockMovingLightSource.getItemLightLevel(mainHand);
        int offHandLight = BlockMovingLightSource.getItemLightLevel(offHand);
        int maxLight = Math.max(mainHandLight, offHandLight);
        return BlockMovingLightSource.getLightBlockForLevel(maxLight);
    }

    public static void clearCache() {
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return true;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
    }

    public void func_176216_a(World worldIn, Entity entityIn) {
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityMovingLightSource();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }
}

