/*
 * Decompiled with CFR 0.152.
 */
package com.blogspot.michaelsebero.movinglightsource.registries;

import com.blogspot.michaelsebero.movinglightsource.blocks.BlockMovingLightSource;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@GameRegistry.ObjectHolder(value="movinglightsource")
public class BlockRegistry {
    public static final BlockMovingLightSource MOVING_LIGHT_SOURCE = new BlockMovingLightSource("movinglightsource");
    public static final BlockMovingLightSource MOVING_LIGHT_SOURCE_15 = new BlockMovingLightSource("movinglightsource_15", 1.0f);
    public static final BlockMovingLightSource MOVING_LIGHT_SOURCE_14 = new BlockMovingLightSource("movinglightsource_14", 0.93333334f);
    public static final BlockMovingLightSource MOVING_LIGHT_SOURCE_13 = new BlockMovingLightSource("movinglightsource_13", 0.8666667f);
    public static final BlockMovingLightSource MOVING_LIGHT_SOURCE_12 = new BlockMovingLightSource("movinglightsource_12", 0.8f);
    public static final BlockMovingLightSource MOVING_LIGHT_SOURCE_11 = new BlockMovingLightSource("movinglightsource_11", 0.73333335f);
    public static final BlockMovingLightSource MOVING_LIGHT_SOURCE_9 = new BlockMovingLightSource("movinglightsource_9", 0.6f);
    public static final BlockMovingLightSource MOVING_LIGHT_SOURCE_7 = new BlockMovingLightSource("movinglightsource_7", 0.46666667f);

    private static void initialize() {
    }

    @Mod.EventBusSubscriber(modid="movinglightsource")
    public static class RegistrationHandler {
        public static final Set<Block> SET_BLOCKS = new HashSet<Block>();
        public static final Set<Item> SET_ITEM_BLOCKS = new HashSet<Item>();

        @SubscribeEvent
        public static void onEvent(RegistryEvent.Register<Block> event) {
            Block[] arrayBlocks = new Block[]{MOVING_LIGHT_SOURCE, MOVING_LIGHT_SOURCE_15, MOVING_LIGHT_SOURCE_14, MOVING_LIGHT_SOURCE_13, MOVING_LIGHT_SOURCE_12, MOVING_LIGHT_SOURCE_11, MOVING_LIGHT_SOURCE_9, MOVING_LIGHT_SOURCE_7};
            IForgeRegistry registry = event.getRegistry();
            for (Block block : arrayBlocks) {
                registry.register((IForgeRegistryEntry)block);
                SET_BLOCKS.add(block);
                System.out.println("Registering block: " + block.getRegistryName());
            }
            BlockRegistry.initialize();
            BlockMovingLightSource.initMapLightSources();
        }

        @SubscribeEvent
        public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
            ItemBlock[] items = new ItemBlock[]{new ItemBlock((Block)MOVING_LIGHT_SOURCE), new ItemBlock((Block)MOVING_LIGHT_SOURCE_15), new ItemBlock((Block)MOVING_LIGHT_SOURCE_14), new ItemBlock((Block)MOVING_LIGHT_SOURCE_13), new ItemBlock((Block)MOVING_LIGHT_SOURCE_12), new ItemBlock((Block)MOVING_LIGHT_SOURCE_11), new ItemBlock((Block)MOVING_LIGHT_SOURCE_9), new ItemBlock((Block)MOVING_LIGHT_SOURCE_7)};
            IForgeRegistry registry = event.getRegistry();
            for (ItemBlock item : items) {
                Block block = item.func_179223_d();
                ResourceLocation registryName = (ResourceLocation)Preconditions.checkNotNull((Object)block.getRegistryName(), (String)"Block %s has null registry name", (Object)block);
                registry.register(item.setRegistryName(registryName));
                SET_ITEM_BLOCKS.add((Item)item);
                System.out.println("Registering Item Block for " + registryName);
            }
        }
    }
}

