/*
 * Decompiled with CFR 0.152.
 */
package com.blogspot.michaelsebero.movinglightsource.utilities;

import com.blogspot.michaelsebero.movinglightsource.MainMod;
import com.blogspot.michaelsebero.movinglightsource.entities.IEntity;
import com.blogspot.michaelsebero.movinglightsource.networking.MessageSyncEntityToClient;
import com.blogspot.michaelsebero.movinglightsource.networking.MessageSyncEntityToServer;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class Utilities {
    public static Item setItemName(Item parItem, String parItemName) {
        parItem.setRegistryName(parItemName);
        parItem.func_77655_b(parItemName);
        return parItem;
    }

    public static Block setBlockName(Block parBlock, String parBlockName) {
        parBlock.setRegistryName(parBlockName);
        parBlock.func_149663_c(parBlockName);
        return parBlock;
    }

    public static String stringToRainbow(String parString, boolean parReturnToBlack) {
        int stringLength = parString.length();
        if (stringLength < 1) {
            return "";
        }
        String outputString = "";
        TextFormatting[] colorChar = new TextFormatting[]{TextFormatting.RED, TextFormatting.GOLD, TextFormatting.YELLOW, TextFormatting.GREEN, TextFormatting.AQUA, TextFormatting.BLUE, TextFormatting.LIGHT_PURPLE, TextFormatting.DARK_PURPLE};
        for (int i = 0; i < stringLength; ++i) {
            outputString = outputString + colorChar[i % 8] + parString.substring(i, i + 1);
        }
        if (parReturnToBlack) {
            return outputString + TextFormatting.BLACK;
        }
        return outputString + TextFormatting.WHITE;
    }

    public static String stringToRainbow(String parString) {
        return Utilities.stringToRainbow(parString, false);
    }

    public static String stringToGolden(String parString, int parShineLocation, boolean parReturnToBlack) {
        int stringLength = parString.length();
        if (stringLength < 1) {
            return "";
        }
        String outputString = "";
        for (int i = 0; i < stringLength; ++i) {
            outputString = ((long)(i + parShineLocation) + Minecraft.func_71386_F() / 20L) % 88L == 0L ? outputString + TextFormatting.WHITE + parString.substring(i, i + 1) : (((long)(i + parShineLocation) + Minecraft.func_71386_F() / 20L) % 88L == 1L ? outputString + TextFormatting.YELLOW + parString.substring(i, i + 1) : (((long)(i + parShineLocation) + Minecraft.func_71386_F() / 20L) % 88L == 87L ? outputString + TextFormatting.YELLOW + parString.substring(i, i + 1) : outputString + TextFormatting.GOLD + parString.substring(i, i + 1)));
        }
        if (parReturnToBlack) {
            return outputString + TextFormatting.BLACK;
        }
        return outputString + TextFormatting.WHITE;
    }

    public static String stringToGolden(String parString, int parShineLocation) {
        return Utilities.stringToGolden(parString, parShineLocation, false);
    }

    public static String multiLineTextFormatting(TextFormatting parTextFormatting, String parString) {
        String theString = "";
        String[] textStr = parString.split("\\r\\n|\\n|\\r");
        for (int i = 0; i < textStr.length; ++i) {
            theString = theString + parTextFormatting + textStr[i] + "\n";
        }
        return theString;
    }

    public static String toPigLatin(String s) {
        String latin = "";
        int i = 0;
        while (i < s.length()) {
            while (i < s.length() && !Utilities.isLetter(s.charAt(i))) {
                latin = latin + s.charAt(i);
                ++i;
            }
            if (i >= s.length()) break;
            int begin = i;
            while (i < s.length() && Utilities.isLetter(s.charAt(i))) {
                ++i;
            }
            int end = i;
            latin = latin + Utilities.pigWord(s.substring(begin, end));
        }
        return latin;
    }

    private static boolean isLetter(char c) {
        return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    private static String pigWord(String word) {
        int split = Utilities.firstVowel(word);
        return word.substring(split) + "-" + word.substring(0, split) + "ay";
    }

    private static int firstVowel(String word) {
        word = word.toLowerCase();
        for (int i = 0; i < word.length(); ++i) {
            if (word.charAt(i) != 'a' && word.charAt(i) != 'e' && word.charAt(i) != 'i' && word.charAt(i) != 'o' && word.charAt(i) != 'u') continue;
            return i;
        }
        return 0;
    }

    public static void sendEntitySyncPacketToClient(IEntity parEntity) {
        Entity theEntity = (Entity)parEntity;
        if (!theEntity.func_130014_f_().field_72995_K) {
            System.out.println("sendEntitySyncPacket from server for entity ID =" + theEntity.func_145782_y());
            MainMod.network.sendToAll((IMessage)new MessageSyncEntityToClient(theEntity.func_145782_y(), parEntity.getSyncDataCompound()));
        }
    }

    public static void sendEntitySyncPacketToServer(IEntity parEntity) {
        Entity theEntity = (Entity)parEntity;
        if (theEntity.func_130014_f_().field_72995_K) {
            System.out.println("sendEntitySyncPacket from client");
            MainMod.network.sendToServer((IMessage)new MessageSyncEntityToServer(theEntity.func_145782_y(), parEntity.getSyncDataCompound()));
        }
    }

    public static double getHeightValue(World parWorld, double parX, double parZ) {
        int intX = MathHelper.func_76128_c((double)parX);
        int intZ = MathHelper.func_76128_c((double)parZ);
        int chunkX = intX >> 4;
        int chunkZ = intZ >> 4;
        double height = parWorld.func_72964_e(chunkX, chunkZ).func_76611_b(intX & 0xF, intZ & 0xF);
        return height;
    }

    public static RayTraceResult getMouseOverExtended(float dist) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        Entity theRenderViewEntity = mc.func_175606_aa();
        AxisAlignedBB theViewBoundingBox = new AxisAlignedBB(theRenderViewEntity.field_70165_t - 0.5, theRenderViewEntity.field_70163_u - 0.0, theRenderViewEntity.field_70161_v - 0.5, theRenderViewEntity.field_70165_t + 0.5, theRenderViewEntity.field_70163_u + 1.5, theRenderViewEntity.field_70161_v + 0.5);
        RayTraceResult returnMOP = null;
        if (mc.field_71441_e != null) {
            double var2 = dist;
            returnMOP = theRenderViewEntity.func_174822_a(var2, 0.0f);
            double calcdist = var2;
            Vec3d pos = theRenderViewEntity.func_174824_e(0.0f);
            var2 = calcdist;
            if (returnMOP != null) {
                calcdist = returnMOP.field_72307_f.func_72438_d(pos);
            }
            Vec3d lookvec = theRenderViewEntity.func_70676_i(0.0f);
            Vec3d var8 = pos.func_72441_c(lookvec.field_72450_a * var2, lookvec.field_72448_b * var2, lookvec.field_72449_c * var2);
            Entity pointedEntity = null;
            float var9 = 1.0f;
            List list = mc.field_71441_e.func_72839_b(theRenderViewEntity, theViewBoundingBox.func_72314_b(lookvec.field_72450_a * var2, lookvec.field_72448_b * var2, lookvec.field_72449_c * var2).func_72321_a((double)var9, (double)var9, (double)var9));
            double d = calcdist;
            for (Entity entity : list) {
                double d1;
                if (!entity.func_70067_L()) continue;
                float bordersize = entity.func_70111_Y();
                AxisAlignedBB aabb = new AxisAlignedBB(entity.field_70165_t - (double)(entity.field_70130_N / 2.0f), entity.field_70163_u, entity.field_70161_v - (double)(entity.field_70130_N / 2.0f), entity.field_70165_t + (double)(entity.field_70130_N / 2.0f), entity.field_70163_u + (double)entity.field_70131_O, entity.field_70161_v + (double)(entity.field_70130_N / 2.0f));
                aabb.func_72321_a((double)bordersize, (double)bordersize, (double)bordersize);
                RayTraceResult mop0 = aabb.func_72327_a(pos, var8);
                if (aabb.func_72318_a(pos)) {
                    if (!(0.0 < d) && d != 0.0) continue;
                    pointedEntity = entity;
                    d = 0.0;
                    continue;
                }
                if (mop0 == null || !((d1 = pos.func_72438_d(mop0.field_72307_f)) < d) && d != 0.0) continue;
                pointedEntity = entity;
                d = d1;
            }
            if (pointedEntity != null && (d < calcdist || returnMOP == null)) {
                returnMOP = new RayTraceResult(pointedEntity);
            }
        }
        return returnMOP;
    }

    public static EntityLivingBase getClosestEntityLiving(World parWorld, BlockPos parPos, double parMaxDistance) {
        if (parMaxDistance <= 0.0) {
            return null;
        }
        EntityLivingBase closestLiving = null;
        double distanceSq = parMaxDistance * parMaxDistance;
        AxisAlignedBB aabb = new AxisAlignedBB((double)parPos.func_177958_n() - parMaxDistance, (double)parPos.func_177956_o() - parMaxDistance, (double)parPos.func_177952_p() - parMaxDistance, (double)parPos.func_177958_n() + parMaxDistance, (double)parPos.func_177956_o() + parMaxDistance, (double)parPos.func_177952_p() + parMaxDistance);
        List listEntitiesInRange = parWorld.func_72872_a(EntityLivingBase.class, aabb);
        for (EntityLivingBase next : listEntitiesInRange) {
            if (!(Utilities.getDistanceSq(next.func_180425_c(), parPos) < distanceSq)) continue;
            closestLiving = next;
        }
        return closestLiving;
    }

    protected static double getDistanceSq(BlockPos parPos1, BlockPos parPos2) {
        return (parPos1.func_177958_n() - parPos2.func_177958_n()) * (parPos1.func_177958_n() - parPos2.func_177958_n()) + (parPos1.func_177956_o() - parPos2.func_177956_o()) * (parPos1.func_177956_o() - parPos2.func_177956_o()) + (parPos1.func_177952_p() - parPos2.func_177952_p()) * (parPos1.func_177952_p() - parPos2.func_177952_p());
    }
}

