/*
 * Decompiled with CFR 0.152.
 */
package co.aikar.commands;

import co.aikar.commands.AnnotationLookups;
import co.aikar.commands.BaseCommand;
import co.aikar.commands.CommandManager;
import co.aikar.commands.LogLevel;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;

class Annotations<M extends CommandManager>
extends AnnotationLookups {
    public static final int NOTHING = 0;
    public static final int REPLACEMENTS = 1;
    public static final int LOWERCASE = 2;
    public static final int UPPERCASE = 4;
    public static final int NO_EMPTY = 8;
    public static final int DEFAULT_EMPTY = 16;
    private final M manager;
    private final Map<Class<? extends Annotation>, Method> valueMethods = new IdentityHashMap<Class<? extends Annotation>, Method>();
    private final Map<Class<? extends Annotation>, Void> noValueAnnotations = new IdentityHashMap<Class<? extends Annotation>, Void>();

    Annotations(M manager) {
        this.manager = manager;
    }

    @Override
    String getAnnotationValue(AnnotatedElement object, Class<? extends Annotation> annoClass, int options) {
        Annotation annotation = Annotations.getAnnotationRecursive(object, annoClass, new HashSet<Annotation>());
        if (annotation == null) {
            if (object instanceof Class) {
                annotation = Annotations.getAnnotationFromParentClasses((Class)object, annoClass);
            } else if (object instanceof Method) {
                annotation = Annotations.getAnnotationFromParentMethods((Method)object, annoClass);
            } else if (object instanceof Parameter) {
                annotation = Annotations.getAnnotationFromParentParameters((Parameter)object, annoClass);
            }
        }
        String value = null;
        if (annotation != null) {
            Method valueMethod = this.valueMethods.get(annoClass);
            if (this.noValueAnnotations.containsKey(annoClass)) {
                value = "";
            } else {
                try {
                    if (valueMethod == null) {
                        valueMethod = annoClass.getMethod("value", new Class[0]);
                        valueMethod.setAccessible(true);
                        this.valueMethods.put(annoClass, valueMethod);
                    }
                    value = (String)valueMethod.invoke((Object)annotation, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    if (!(e instanceof NoSuchMethodException)) {
                        ((CommandManager)this.manager).log(LogLevel.ERROR, "Error getting annotation value", e);
                    }
                    this.noValueAnnotations.put(annoClass, null);
                    value = "";
                }
            }
        }
        if (value == null) {
            if (Annotations.hasOption(options, 16)) {
                value = "";
            } else {
                return null;
            }
        }
        if (Annotations.hasOption(options, 1)) {
            value = ((CommandManager)this.manager).getCommandReplacements().replace(value);
        }
        if (Annotations.hasOption(options, 2)) {
            value = value.toLowerCase(((CommandManager)this.manager).getLocales().getDefaultLocale());
        } else if (Annotations.hasOption(options, 4)) {
            value = value.toUpperCase(((CommandManager)this.manager).getLocales().getDefaultLocale());
        }
        if (value.isEmpty() && Annotations.hasOption(options, 8)) {
            value = null;
        }
        return value;
    }

    private static Annotation getAnnotationFromParentClasses(Class<?> clazz, Class<? extends Annotation> annoClass) {
        for (Class<?> parent = clazz.getSuperclass(); parent != null && !parent.equals(BaseCommand.class) && !parent.equals(Object.class); parent = parent.getSuperclass()) {
            Annotation annotation = Annotations.getAnnotationRecursive(parent, annoClass, new HashSet<Annotation>());
            if (annotation == null) continue;
            return annotation;
        }
        return null;
    }

    private static Annotation getAnnotationFromParentMethods(Method method, Class<? extends Annotation> annoClass) {
        for (Class<?> clazz = method.getDeclaringClass().getSuperclass(); clazz != null && !clazz.equals(BaseCommand.class) && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            try {
                Method parentMethod = clazz.getDeclaredMethod(method.getName(), method.getParameterTypes());
                Annotation parentAnnotation = Annotations.getAnnotationRecursive(parentMethod, annoClass, new HashSet<Annotation>());
                if (parentAnnotation == null) continue;
                return parentAnnotation;
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return null;
    }

    private static Annotation getAnnotationFromParentParameters(Parameter parameter, Class<? extends Annotation> annoClass) {
        for (Class<?> clazz = parameter.getDeclaringExecutable().getDeclaringClass().getSuperclass(); clazz != null && !clazz.equals(BaseCommand.class) && !clazz.equals(Object.class); clazz = clazz.getSuperclass()) {
            try {
                Method parentMethod = clazz.getDeclaredMethod(parameter.getDeclaringExecutable().getName(), parameter.getDeclaringExecutable().getParameterTypes());
                Annotation parentAnnotation = Arrays.stream(parentMethod.getParameters()).filter(parentParameter -> parentParameter.getName().equals(parameter.getName()) && parentParameter.getType().equals(parameter.getType())).findFirst().map(parentParameter -> Annotations.getAnnotationRecursive(parentParameter, annoClass, new HashSet<Annotation>())).orElse(null);
                if (parentAnnotation == null) continue;
                return parentAnnotation;
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return null;
    }

    private static Annotation getAnnotationRecursive(AnnotatedElement object, Class<? extends Annotation> annoClass, Collection<Annotation> checked) {
        if (object.isAnnotationPresent(annoClass)) {
            return object.getAnnotation(annoClass);
        }
        for (Annotation otherAnnotation : object.getDeclaredAnnotations()) {
            if (otherAnnotation.annotationType().getPackage().getName().startsWith("java.")) continue;
            if (checked.contains(otherAnnotation)) {
                return null;
            }
            checked.add(otherAnnotation);
            Annotation foundAnnotation = Annotations.getAnnotationRecursive(otherAnnotation.annotationType(), annoClass, checked);
            if (foundAnnotation == null) continue;
            return foundAnnotation;
        }
        return null;
    }

    private static boolean hasOption(int options, int option) {
        return (options & option) == option;
    }
}

