/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover;

import co.aikar.commands.PaperCommandManager;
import java.io.File;
import me.chrommob.baritoneremover.checks.inter.Checks;
import me.chrommob.baritoneremover.commands.DebugCommand;
import me.chrommob.baritoneremover.commands.ReloadCommand;
import me.chrommob.baritoneremover.config.ConfigManager;
import me.chrommob.baritoneremover.data.DataHolder;
import me.chrommob.baritoneremover.data.Scheduler;
import me.chrommob.baritoneremover.libs.bstats.bukkit.Metrics;
import me.chrommob.baritoneremover.libs.com.packetevents.PacketEvents;
import me.chrommob.baritoneremover.libs.io.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import me.chrommob.baritoneremover.listener.BlockPlaceListener;
import me.chrommob.baritoneremover.listener.DisconnectListener;
import me.chrommob.baritoneremover.listener.MiningListener;
import me.chrommob.baritoneremover.listener.RotationListener;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class BaritoneRemover
extends JavaPlugin {
    private DataHolder dataHolder;
    private Checks checks;
    private ConfigManager configManager;
    private File configFile;
    private File debugFolder;
    private static Scheduler scheduler;

    public static Scheduler scheduler() {
        return scheduler;
    }

    public void onLoad() {
        scheduler = new Scheduler(this);
        File dataFolder = this.getDataFolder();
        this.configFile = new File(dataFolder, "config.yml");
        this.debugFolder = new File(dataFolder, "debug");
        if (!dataFolder.exists()) {
            dataFolder.mkdirs();
        }
        if (!this.debugFolder.exists()) {
            this.debugFolder.mkdirs();
        }
        PacketEvents.setAPI(SpigotPacketEventsBuilder.build((Plugin)this));
        PacketEvents.getAPI().getSettings().reEncodeByDefault(false).checkForUpdates(false).bStats(true);
        PacketEvents.getAPI().load();
    }

    public void onEnable() {
        PaperCommandManager commandManager = new PaperCommandManager((Plugin)this);
        new Metrics(this, 19704);
        this.dataHolder = new DataHolder(this);
        this.checks = new Checks(this);
        this.configManager = new ConfigManager(this);
        commandManager.registerCommand(new DebugCommand(this));
        commandManager.registerCommand(new ReloadCommand(this));
        this.getServer().getPluginManager().registerEvents((Listener)new BlockPlaceListener(this), (Plugin)this);
        PacketEvents.getAPI().getEventManager().registerListener(new RotationListener(this));
        PacketEvents.getAPI().getEventManager().registerListener(new DisconnectListener(this));
        PacketEvents.getAPI().getEventManager().registerListener(new MiningListener(this));
        PacketEvents.getAPI().init();
    }

    public void reload() {
        this.configManager.loadConfig();
        this.dataHolder.clear();
    }

    public void onDisable() {
        PacketEvents.getAPI().terminate();
    }

    public DataHolder dataHolder() {
        return this.dataHolder;
    }

    public Checks checks() {
        return this.checks;
    }

    public File configFile() {
        return this.configFile;
    }

    public File debugFolder() {
        return this.debugFolder;
    }
}

