/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.checks.impl.movement;

import me.chrommob.baritoneremover.checks.inter.Check;
import me.chrommob.baritoneremover.checks.inter.CheckData;
import me.chrommob.baritoneremover.checks.inter.CheckType;
import me.chrommob.baritoneremover.data.PacketDatas;
import me.chrommob.baritoneremover.data.PlayerData;
import me.chrommob.baritoneremover.data.types.PacketData;
import org.bukkit.Bukkit;
import org.bukkit.entity.Boat;

@CheckData(name="AutoWalk", identifier="A", description="Checks if the player is walking while changing their yaw but not their pitch", checkType=CheckType.FLYING)
public class AutoWalkA
extends Check {
    private double distanceMoved = 0.0;
    private int ticks = 0;

    public AutoWalkA(PlayerData playerData) {
        super(playerData);
    }

    @Override
    public void run() {
        if (this.playerData.isBedrock() && Bukkit.getPlayer((String)this.playerData.name()) != null && Bukkit.getPlayer((String)this.playerData.name()).getVehicle() instanceof Boat) {
            return;
        }
        PacketDatas packetDataList = this.playerData.packetDataList();
        if (packetDataList.size(CheckType.FLYING) < 2) {
            return;
        }
        PacketData latest = packetDataList.getLatest(CheckType.FLYING);
        if (latest == null) {
            return;
        }
        if (Math.abs(latest.rotationData().pitch()) == 90.0f) {
            return;
        }
        PacketData previous = packetDataList.getPrevious(latest, CheckType.FLYING);
        float differencePitch = latest.differencePitch(previous);
        if (differencePitch > 0.0f) {
            if (this.ticks > 0) {
                --this.ticks;
            }
            return;
        }
        double distance = latest.distance(previous);
        this.distanceMoved += distance;
        ++this.ticks;
        if (this.distanceMoved < 20.0) {
            return;
        }
        if ((double)this.ticks / this.distanceMoved < 3.0) {
            this.debug("Ticks: " + this.ticks + " Distance: " + this.distanceMoved + " Ticks/Distance: " + (double)this.ticks / this.distanceMoved);
            this.distanceMoved = 0.0;
            this.ticks = 0;
            return;
        }
        this.increaseVl(Math.round(Math.round((double)this.ticks / this.distanceMoved / 3.0)));
        this.distanceMoved = 0.0;
        this.ticks = 0;
    }
}

