/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.checks.impl.movement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.chrommob.baritoneremover.checks.inter.Check;
import me.chrommob.baritoneremover.checks.inter.CheckData;
import me.chrommob.baritoneremover.checks.inter.CheckType;
import me.chrommob.baritoneremover.checks.inter.Utils;
import me.chrommob.baritoneremover.data.PlayerData;
import me.chrommob.baritoneremover.data.types.PacketData;
import me.chrommob.baritoneremover.data.types.PositionData;

@CheckData(name="Repeated", identifier="B", checkType=CheckType.AGGREGATE, description="Checks if the player is moving in a repeated sequence")
public class RepeatedB
extends Check {
    public RepeatedB(PlayerData playerData) {
        super(playerData);
    }

    @Override
    public void run() {
        int n;
        int n2;
        List<PacketData> packetDatas = this.playerData.packetDataList().getAllType(CheckType.FLYING, CheckType.POSITION);
        if (packetDatas.size() < 2) {
            return;
        }
        HashMap same = new HashMap();
        for (PacketData packetData : packetDatas) {
            PositionData positionData = packetData.positionData();
            List indexes = same.containsKey(positionData) ? (List)same.get(positionData) : new ArrayList();
            indexes.add(packetData.index());
            same.put(positionData, indexes);
        }
        HashMap patternToPositionDataMap = new HashMap();
        for (Map.Entry entry : same.entrySet()) {
            PositionData rotationData = (PositionData)entry.getKey();
            List indexes = (List)entry.getValue();
            if (indexes.size() < 2) continue;
            List<Integer> pattern = Utils.computePattern(indexes);
            if (!patternToPositionDataMap.containsKey(pattern)) {
                patternToPositionDataMap.put(pattern, new ArrayList());
            }
            ((List)patternToPositionDataMap.get(pattern)).add(rotationData);
        }
        boolean bl = false;
        boolean bl2 = false;
        int totalBlocks = 0;
        List maxPatternData = null;
        for (Map.Entry patternEntry : patternToPositionDataMap.entrySet()) {
            int patternRepeats;
            List pattern = (List)patternEntry.getKey();
            List rotationDataList = (List)patternEntry.getValue();
            int patternLength = pattern.size();
            int blocks = patternLength * (patternRepeats = rotationDataList.size());
            if (blocks <= totalBlocks) continue;
            maxPatternData = rotationDataList;
            totalBlocks = blocks;
            n2 = patternLength;
            n = patternRepeats;
        }
        StringBuilder patternBuilder = new StringBuilder();
        if (maxPatternData == null) {
            return;
        }
        for (PositionData data : maxPatternData) {
            patternBuilder.append(data.toString()).append(" ");
        }
        this.debug("totalBlocks: " + (int)(n2 * n) + " maxPatternLength: " + n2 + " maxPatternRepeats: " + n);
        this.debug("pattern: " + patternBuilder);
        if (totalBlocks > 200 && n2 > 1 && n > 1) {
            this.increaseVl(this.punishVl());
        }
    }
}

