/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.checks.impl.rotation;

import java.util.ArrayList;
import java.util.List;
import me.chrommob.baritoneremover.checks.inter.Check;
import me.chrommob.baritoneremover.checks.inter.CheckData;
import me.chrommob.baritoneremover.checks.inter.CheckType;
import me.chrommob.baritoneremover.checks.inter.GraphResult;
import me.chrommob.baritoneremover.checks.inter.Utils;
import me.chrommob.baritoneremover.data.PlayerData;
import me.chrommob.baritoneremover.data.types.PacketData;
import me.chrommob.baritoneremover.data.types.RotationData;

@CheckData(name="Cinematic", identifier="A", checkType=CheckType.ROTATION, description="Checks if the player is rotating in a cinematic way")
public class Cinematic
extends Check {
    private long lastSmooth = 0L;
    private long lastHighRate = 0L;
    private double lastDeltaYaw = 0.0;
    private double lastDeltaPitch = 0.0;
    private final List<Double> yawSamples = new ArrayList<Double>();
    private final List<Double> pitchSamples = new ArrayList<Double>();

    public Cinematic(PlayerData playerData) {
        super(playerData);
    }

    @Override
    public void run() {
        boolean cinematic;
        long now = System.currentTimeMillis();
        if (this.playerData.packetDataList().size(CheckType.ROTATION) < 2) {
            return;
        }
        PacketData packetData = this.playerData.packetDataList().getLatest(CheckType.ROTATION, CheckType.FLYING);
        PacketData previous = this.playerData.packetDataList().getPrevious(packetData, CheckType.ROTATION, CheckType.FLYING);
        RotationData rotationUpdate = packetData.rotationData();
        RotationData previousRotation = previous.rotationData();
        double deltaYaw = rotationUpdate.differenceYaw(previousRotation);
        double deltaPitch = rotationUpdate.differencePitch(previousRotation);
        double differenceYaw = Math.abs(deltaYaw - this.lastDeltaYaw);
        double differencePitch = Math.abs(deltaPitch - this.lastDeltaPitch);
        double joltYaw = Math.abs(differenceYaw - deltaYaw);
        double joltPitch = Math.abs(differencePitch - deltaPitch);
        boolean bl = cinematic = now - this.lastHighRate > 250L || now - this.lastSmooth < 9000L;
        if (joltYaw > 1.0 && joltPitch > 1.0) {
            this.lastHighRate = now;
        }
        if (deltaYaw > 0.0 && deltaPitch > 0.0) {
            this.yawSamples.add(deltaYaw);
            this.pitchSamples.add(deltaPitch);
        }
        if (this.yawSamples.size() == 20 && this.pitchSamples.size() == 20) {
            GraphResult resultsYaw = Utils.getGraph(this.yawSamples);
            GraphResult resultsPitch = Utils.getGraph(this.pitchSamples);
            int negativesYaw = resultsYaw.negatives;
            int negativesPitch = resultsPitch.negatives;
            int positivesYaw = resultsYaw.positives;
            int positivesPitch = resultsPitch.positives;
            if (positivesYaw > negativesYaw || positivesPitch > negativesPitch) {
                this.lastSmooth = now;
            }
            this.yawSamples.clear();
            this.pitchSamples.clear();
        }
        this.playerData.setCinematic(cinematic);
        this.lastDeltaYaw = deltaYaw;
        this.lastDeltaPitch = deltaPitch;
    }
}

