/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.checks.impl.rotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.chrommob.baritoneremover.checks.inter.Check;
import me.chrommob.baritoneremover.checks.inter.CheckData;
import me.chrommob.baritoneremover.checks.inter.CheckType;
import me.chrommob.baritoneremover.checks.inter.Utils;
import me.chrommob.baritoneremover.data.PlayerData;
import me.chrommob.baritoneremover.data.types.PacketData;
import me.chrommob.baritoneremover.data.types.RotationData;

@CheckData(name="Repeated", identifier="A", checkType=CheckType.AGGREGATE, description="Checks if the player is rotating in a repeated sequence")
public class RepeatedA
extends Check {
    public RepeatedA(PlayerData playerData) {
        super(playerData);
    }

    @Override
    public void run() {
        int n;
        int n2;
        if (this.playerData.isCinematic()) {
            return;
        }
        List<PacketData> packetDatas = this.playerData.packetDataList().getAllType(CheckType.FLYING, CheckType.ROTATION);
        if (packetDatas.size() < 2) {
            return;
        }
        HashMap same = new HashMap();
        for (PacketData packetData : packetDatas) {
            RotationData rotationData = packetData.rotationData();
            List indexes = same.containsKey(rotationData) ? (List)same.get(rotationData) : new ArrayList();
            indexes.add(packetData.index());
            same.put(rotationData, indexes);
        }
        HashMap patternToRotationDataMap = new HashMap();
        for (Map.Entry entry : same.entrySet()) {
            RotationData rotationData = (RotationData)entry.getKey();
            List indexes = (List)entry.getValue();
            if (indexes.size() < 2) continue;
            List<Integer> pattern = Utils.computePattern(indexes);
            if (!patternToRotationDataMap.containsKey(pattern)) {
                patternToRotationDataMap.put(pattern, new ArrayList());
            }
            ((List)patternToRotationDataMap.get(pattern)).add(rotationData);
        }
        boolean bl = false;
        boolean bl2 = false;
        int totalRotations = 0;
        List maxPatternData = null;
        for (Map.Entry patternEntry : patternToRotationDataMap.entrySet()) {
            int patternRepeats;
            List pattern = (List)patternEntry.getKey();
            List rotationDataList = (List)patternEntry.getValue();
            int patternLength = pattern.size();
            int totalPatternRotations = patternLength * (patternRepeats = rotationDataList.size());
            if (totalPatternRotations <= totalRotations) continue;
            maxPatternData = rotationDataList;
            n2 = patternLength;
            n = patternRepeats;
            totalRotations = totalPatternRotations;
        }
        if (maxPatternData == null) {
            return;
        }
        StringBuilder patternBuilder = new StringBuilder();
        for (RotationData rotationData : maxPatternData) {
            patternBuilder.append(rotationData.toString()).append(" ");
        }
        this.debug("pattern: " + patternBuilder);
        this.debug("totalRotations: " + totalRotations + " maxPatternLength: " + n2 + " maxPatternRepeats: " + n);
        if (totalRotations > 200 && n2 > 1 && n > 1) {
            this.increaseVl(this.punishVl());
        }
    }
}

