/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.checks.impl.rotation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.chrommob.baritoneremover.checks.impl.rotation.Data;
import me.chrommob.baritoneremover.checks.inter.Check;
import me.chrommob.baritoneremover.checks.inter.CheckData;
import me.chrommob.baritoneremover.checks.inter.CheckType;
import me.chrommob.baritoneremover.checks.inter.Utils;
import me.chrommob.baritoneremover.data.PlayerData;
import me.chrommob.baritoneremover.data.types.PacketData;

@CheckData(name="Repeated", identifier="C", checkType=CheckType.AGGREGATE, description="Checks if the player is changing rotation in a repeated sequence")
public class RepeatedC
extends Check {
    public RepeatedC(PlayerData playerData) {
        super(playerData);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run() {
        int n;
        int n2;
        if (this.playerData.isCinematic()) {
            return;
        }
        List<PacketData> packetDatas = this.playerData.packetDataList().getAllType(CheckType.FLYING, CheckType.ROTATION);
        if (packetDatas.size() < 2) {
            return;
        }
        ArrayList<Data> datas = new ArrayList<Data>();
        for (int i = 0; i < packetDatas.size() - 1; ++i) {
            PacketData packetData = packetDatas.get(i);
            PacketData packetData2 = packetDatas.get(i + 1);
            float f = packetData.rotationData().differenceYaw(packetData2.rotationData());
            float pitchDifference = packetData.rotationData().differencePitch(packetData2.rotationData());
            datas.add(new Data(f, pitchDifference, packetData.index()));
        }
        HashMap<Data, void> same = new HashMap<Data, void>();
        for (Data data : datas) {
            void var6_15;
            if (same.containsKey(data)) {
                List list = (List)same.get(data);
            } else {
                ArrayList arrayList = new ArrayList();
            }
            var6_15.add(data.index);
            same.put(data, var6_15);
        }
        HashMap patternToDataMap = new HashMap();
        for (Map.Entry entry : same.entrySet()) {
            Data data = (Data)entry.getKey();
            List indexes = (List)entry.getValue();
            if (indexes.size() < 2) continue;
            List<Integer> pattern = Utils.computePattern(indexes);
            if (!patternToDataMap.containsKey(pattern)) {
                patternToDataMap.put(pattern, new ArrayList());
            }
            ((List)patternToDataMap.get(pattern)).add(data);
        }
        boolean bl = false;
        boolean bl2 = false;
        int totalPatternsC = 0;
        List maxPatternData = null;
        for (Map.Entry patternEntry : patternToDataMap.entrySet()) {
            int patternRepeats;
            List pattern = (List)patternEntry.getKey();
            List rotationDataList = (List)patternEntry.getValue();
            int patternLength = pattern.size();
            int totalPatterns = patternLength * (patternRepeats = rotationDataList.size());
            if (totalPatterns <= totalPatternsC) continue;
            maxPatternData = rotationDataList;
            totalPatternsC = totalPatterns;
            n2 = patternLength;
            n = patternRepeats;
        }
        StringBuilder patternBuilder = new StringBuilder();
        if (maxPatternData == null) {
            return;
        }
        for (Data data : maxPatternData) {
            patternBuilder.append(data.toString()).append(" ");
        }
        this.debug("totalPatternsC: " + (int)(n2 * n) + " maxPatternLength: " + n2 + " maxPatternRepeats: " + n);
        this.debug("pattern: " + patternBuilder);
        if (totalPatternsC > 200 && n2 > 1 && n > 1) {
            this.increaseVl(this.punishVl());
        }
    }
}

