/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.checks.impl.rotation;

import java.util.ArrayList;
import java.util.List;
import me.chrommob.baritoneremover.checks.inter.Check;
import me.chrommob.baritoneremover.checks.inter.CheckData;
import me.chrommob.baritoneremover.checks.inter.CheckType;
import me.chrommob.baritoneremover.data.PacketDatas;
import me.chrommob.baritoneremover.data.PlayerData;
import me.chrommob.baritoneremover.data.types.PacketData;

@CheckData(name="TimeBetween", identifier="A", description="Checks the time it took to start mining a block after mining the previous block", checkType=CheckType.MINING)
public class TimeBetweenA
extends Check {
    private List<Float> lastRotates = new ArrayList<Float>();

    public TimeBetweenA(PlayerData playerData) {
        super(playerData);
    }

    @Override
    public void run() {
        PacketDatas packetDatas = this.playerData.packetDataList();
        if (packetDatas.size(CheckType.MINING) == 0) {
            return;
        }
        PacketData latest = packetDatas.getLatest(CheckType.MINING);
        if (latest == null) {
            return;
        }
        PacketData previous = packetDatas.getPrevious(latest, CheckType.MINED);
        if (previous == null) {
            return;
        }
        PacketData latestRotation = packetDatas.getLatest(CheckType.ROTATION);
        PacketData latestFlying = packetDatas.getLatest(CheckType.FLYING);
        if (latestRotation == null && latestFlying == null) {
            return;
        }
        PacketData latestRotationInfo = latestRotation == null ? latestFlying : (latestFlying == null ? latestRotation : (latestRotation.timeStamp() > latestFlying.timeStamp() ? latestRotation : latestFlying));
        PacketData previousRotation = packetDatas.getPrevious(previous, CheckType.ROTATION);
        PacketData previousFlying = packetDatas.getPrevious(previous, CheckType.FLYING);
        if (previousRotation == null && previousFlying == null) {
            return;
        }
        PacketData previousRotationInfo = previousRotation == null ? previousFlying : (previousFlying == null ? previousRotation : (previousRotation.timeStamp() > previousFlying.timeStamp() ? previousRotation : previousFlying));
        float distance = latestRotationInfo.rotationData().distance(previousRotationInfo.rotationData());
        if (distance == 0.0f) {
            return;
        }
        long time = latest.timeStamp() - previous.timeStamp();
        if (time <= 0L) {
            this.debug("timeA is lower or equal to 0 this shouldn't happen (" + time + ")");
            return;
        }
        float timeToRotate = (float)time / distance;
        if (this.lastRotates.size() >= 10) {
            this.lastRotates.remove(0);
        }
        this.lastRotates.add(Float.valueOf(timeToRotate));
        if (this.lastRotates.size() < 2) {
            return;
        }
        double sum = 0.0;
        for (float number : this.lastRotates) {
            sum += (double)number;
        }
        double mean = sum / (double)this.lastRotates.size();
        double squaredDifferencesSum = 0.0;
        for (float number : this.lastRotates) {
            double difference = (double)number - mean;
            squaredDifferencesSum += difference * difference;
        }
        double meanOfSquaredDifferences = squaredDifferencesSum / (double)this.lastRotates.size();
        double standardDeviation = Math.sqrt(meanOfSquaredDifferences);
        if (standardDeviation < 10000.0) {
            return;
        }
        this.debug("timeToRotateA: " + timeToRotate + " standardDeviation: " + standardDeviation);
        if (timeToRotate > 2.0f) {
            return;
        }
        this.increaseVl(Math.round(1.0f / timeToRotate));
    }
}

