/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.checks.impl.rotation;

import me.chrommob.baritoneremover.checks.inter.Check;
import me.chrommob.baritoneremover.checks.inter.CheckData;
import me.chrommob.baritoneremover.checks.inter.CheckType;
import me.chrommob.baritoneremover.data.PacketDatas;
import me.chrommob.baritoneremover.data.PlayerData;
import me.chrommob.baritoneremover.data.types.PacketData;

@CheckData(name="TimeBetween", identifier="B", description="Checks the time it took to place a block after placing the previous block", checkType=CheckType.PLACE)
public class TimeBetweenB
extends Check {
    public TimeBetweenB(PlayerData playerData) {
        super(playerData);
    }

    @Override
    public void run() {
        PacketDatas packetDatas = this.playerData.packetDataList();
        if (packetDatas.size(this.checkType()) < 2) {
            return;
        }
        PacketData latest = packetDatas.getLatest(this.checkType());
        PacketData previous = packetDatas.getPrevious(latest, this.checkType());
        PacketData latestRotation = packetDatas.getLatest(CheckType.ROTATION);
        PacketData latestFlying = packetDatas.getLatest(CheckType.FLYING);
        if (latestRotation == null && latestFlying == null) {
            return;
        }
        PacketData latestRotationInfo = latestRotation == null ? latestFlying : (latestFlying == null ? latestRotation : (latestRotation.timeStamp() > latestFlying.timeStamp() ? latestRotation : latestFlying));
        PacketData previousRotation = packetDatas.getPrevious(previous, CheckType.ROTATION);
        PacketData previousFlying = packetDatas.getPrevious(previous, CheckType.FLYING);
        if (previousRotation == null && previousFlying == null) {
            return;
        }
        PacketData previousRotationInfo = previousRotation == null ? previousFlying : (previousFlying == null ? previousRotation : (previousRotation.timeStamp() > previousFlying.timeStamp() ? previousRotation : previousFlying));
        float distance = latestRotationInfo.rotationData().distance(previousRotationInfo.rotationData());
        this.debug("distanceB: " + distance);
        if (distance < 3.0f || distance > 200.0f) {
            return;
        }
        long time = latest.timeStamp() - previous.timeStamp();
        if (time <= 0L) {
            this.debug("timeB is lower or equal to 0 this shouldn't happen (" + time + ")");
            return;
        }
        float timeToRotate = (float)time / distance;
        this.debug("timeToRotateB: " + timeToRotate);
        if (timeToRotate > 2.0f) {
            return;
        }
        this.increaseVl(Math.round(1.0f / timeToRotate));
    }
}

