/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.checks.inter;

import me.chrommob.baritoneremover.BaritoneRemover;
import me.chrommob.baritoneremover.checks.inter.CheckData;
import me.chrommob.baritoneremover.checks.inter.CheckType;
import me.chrommob.baritoneremover.config.ConfigManager;
import me.chrommob.baritoneremover.data.PlayerData;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.Component;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.TextReplacementConfig;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.event.HoverEventSource;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.format.NamedTextColor;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.format.StyleSetter;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;

public abstract class Check {
    private CheckType checkType;
    private final String name;
    private final String identifier;
    private final String description;
    private final int punishVl;
    public final PlayerData playerData;
    private final String playerName;
    private final boolean punish;
    private final String punishment;
    private final boolean hidden;
    private int currentVl = 0;
    private long latestFlag = System.currentTimeMillis();

    public Check(PlayerData playerData) {
        boolean annotationPresent = this.getClass().isAnnotationPresent(CheckData.class);
        this.name = annotationPresent ? this.getClass().getAnnotation(CheckData.class).name() : "Unknown";
        this.identifier = annotationPresent ? this.getClass().getAnnotation(CheckData.class).identifier() : "Unknown";
        this.description = annotationPresent ? this.getClass().getAnnotation(CheckData.class).description() : "Unknown";
        CheckType checkType = this.checkType = annotationPresent ? this.getClass().getAnnotation(CheckData.class).checkType() : CheckType.NONE;
        if (!ConfigManager.getInstance().getConfigData(this.getClass()).enable()) {
            this.checkType = CheckType.NONE;
        }
        this.hidden = annotationPresent && this.getClass().getAnnotation(CheckData.class).hidden();
        this.punishVl = ConfigManager.getInstance().getConfigData(this.getClass()).punishVl();
        this.punishment = ConfigManager.getInstance().getConfigData(this.getClass()).punishCommand().replace("%player%", playerData.name());
        this.punish = ConfigManager.getInstance().getConfigData(this.getClass()).punish();
        this.playerData = playerData;
        this.playerName = playerData.name();
        BaritoneRemover.scheduler().runTimer(() -> {
            if (System.currentTimeMillis() - this.latestFlag > 20000L) {
                this.currentVl = this.currentVl > 0 ? this.currentVl - 1 : 0;
            }
        }, 0L, 200L);
    }

    public abstract void run();

    public void increaseVl(int amount) {
        if (this.hidden) {
            return;
        }
        this.latestFlag = System.currentTimeMillis();
        this.currentVl += amount;
        if (this.currentVl == 0) {
            return;
        }
        this.alert();
        if (this.currentVl >= this.punishVl) {
            this.currentVl = 0;
            this.punish();
        }
    }

    public void resetVl() {
        this.currentVl = 0;
    }

    private void alert() {
        int currentVl = this.currentVl;
        StyleSetter message = ConfigManager.getInstance().punishmentMessage().replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{player}").replacement(this.playerName).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{check}").replacement(this.name + " (" + this.identifier + ")").build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{vl}").replacement(String.valueOf(currentVl)).build()).replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("{punish-vl}").replacement(String.valueOf(this.punishVl)).build()).hoverEvent((HoverEventSource)Component.text(this.description).color(NamedTextColor.AQUA));
        ConfigManager.getInstance().adventure().permission("br.alert").sendMessage((Component)message);
        String messageString = PlainTextComponentSerializer.plainText().serialize((Component)message);
        ConfigManager.getInstance().appendDebug(messageString);
        String json = "{\"content\": \"Player " + this.playerName + " has been flagged for " + this.name + " (" + this.identifier + ") (VL: " + currentVl + "/" + this.punishVl + ")\"}";
        ConfigManager.getInstance().sender().add(json, this.playerName, currentVl >= this.punishVl);
    }

    public void debug(String text) {
        String message = "Debug: " + this.playerName + " " + this.name + " (" + this.identifier + ") " + text;
        ConfigManager.getInstance().appendDebug(message);
        if (this.playerData.isDebug()) {
            ConfigManager.getInstance().adventure().player(Bukkit.getPlayer((String)this.playerName)).sendMessage(ConfigManager.getInstance().prefix().append(Component.text("Debug: ").color(NamedTextColor.WHITE)).append(Component.text(text).color(NamedTextColor.RED)));
        }
    }

    private void punish() {
        if (!this.punish) {
            return;
        }
        BaritoneRemover.scheduler().run(() -> ((BaritoneRemover)BaritoneRemover.getPlugin(BaritoneRemover.class)).getServer().dispatchCommand((CommandSender)((BaritoneRemover)BaritoneRemover.getPlugin(BaritoneRemover.class)).getServer().getConsoleSender(), this.punishment));
    }

    public CheckType checkType() {
        return this.checkType;
    }

    public int currentVl() {
        return this.currentVl;
    }

    public int punishVl() {
        return this.punishVl;
    }
}

