/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.checks.inter;

import java.util.ArrayList;
import java.util.List;
import me.chrommob.baritoneremover.checks.inter.GraphResult;

public class Utils {
    public static List<Integer> computePattern(List<Integer> indexes) {
        ArrayList<Integer> pattern = new ArrayList<Integer>();
        int diff = indexes.get(1) - indexes.get(0);
        for (int i = 1; i < indexes.size(); ++i) {
            pattern.add(indexes.get(i) - indexes.get(i - 1));
        }
        pattern.add(0, diff);
        return pattern;
    }

    public static GraphResult getGraph(List<Double> values) {
        double largest = 0.0;
        for (double value : values) {
            if (!(value > largest)) continue;
            largest = value;
        }
        int GRAPH_HEIGHT = 2;
        int positives = 0;
        int negatives = 0;
        for (int i = GRAPH_HEIGHT - 1; i > 0; --i) {
            for (double index : values) {
                double value = (double)GRAPH_HEIGHT * index / largest;
                if (value > (double)i && value < (double)(i + 1)) {
                    ++positives;
                    continue;
                }
                ++negatives;
            }
        }
        return new GraphResult(positives, negatives);
    }
}

