/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.config;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import me.chrommob.baritoneremover.BaritoneRemover;
import me.chrommob.baritoneremover.checks.inter.Check;
import me.chrommob.baritoneremover.checks.inter.CheckData;
import me.chrommob.baritoneremover.checks.inter.Checks;
import me.chrommob.baritoneremover.config.ConfigData;
import me.chrommob.baritoneremover.libs.kyori.adventure.platform.bukkit.BukkitAudiences;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.Component;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.TextComponent;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.format.NamedTextColor;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.minimessage.MiniMessage;
import me.chrommob.baritoneremover.webhook.Sender;
import org.bukkit.plugin.Plugin;
import org.geysermc.floodgate.api.FloodgateApi;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class ConfigManager {
    private final File configFile;
    private File debugFile;
    private final Yaml yaml;
    private static ConfigManager instance;
    private final Checks checks;
    private final Sender sender = new Sender(this);
    private final Map<Class<? extends Check>, ConfigData> configDataMap = new HashMap<Class<? extends Check>, ConfigData>();
    private Component prefix;
    private Component punishmentMessage;
    private double minTps;
    private boolean webHookEnabled;
    private String webHookUrl;
    private LinkedHashMap<String, Object> config;
    private final BukkitAudiences adventure;
    private FloodgateApi floodgateApi;
    private final MiniMessage miniMessage = MiniMessage.miniMessage();

    public BukkitAudiences adventure() {
        if (this.adventure == null) {
            throw new IllegalStateException("Tried to access Adventure when the plugin was disabled!");
        }
        return this.adventure;
    }

    public ConfigManager(BaritoneRemover pl) {
        instance = this;
        try {
            Class.forName("org.geysermc.floodgate.api.FloodgateApi");
            this.floodgateApi = FloodgateApi.getInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        this.adventure = BukkitAudiences.create((Plugin)pl);
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        dumperOptions.setIndent(2);
        dumperOptions.setPrettyFlow(true);
        this.yaml = new Yaml(dumperOptions);
        this.configFile = pl.configFile();
        this.checks = pl.checks();
        this.getCurrentDebugFile();
        this.loadConfig();
    }

    private void getCurrentDebugFile() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd-");
        Date currentDate = new Date();
        String formattedDate = dateFormat.format(currentDate);
        int index = 1;
        File temp = new File(this.plugin().debugFolder(), formattedDate + index + ".log");
        while (temp.exists()) {
            temp = new File(this.plugin().debugFolder(), formattedDate + ++index + ".log");
        }
        this.debugFile = temp;
        try {
            this.debugFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.appendDebug("BaritoneRemover successfully loaded!");
    }

    public void loadConfig() {
        this.propagateDefault();
        try (FileReader reader2 = new FileReader(this.configFile);){
            this.config = this.merge((LinkedHashMap)this.yaml.load((Reader)reader2), this.config);
        }
        catch (IOException reader2) {
            // empty catch block
        }
        this.saveConfig();
        this.minTps = this.config.get("min-tps") instanceof String ? Double.parseDouble((String)this.config.get("min-tps")) : (Double)this.config.get("min-tps");
        this.prefix = this.miniMessage.deserializeOr(this.config.get("prefix").toString(), ((TextComponent)((TextComponent)Component.text("[").color(NamedTextColor.WHITE)).append(Component.text("BaritoneRemover").color(NamedTextColor.RED))).append(Component.text("] ").color(NamedTextColor.WHITE)));
        this.punishmentMessage = this.miniMessage.deserialize((String)this.config.get("punishment-message"));
        Map webHook = (Map)this.config.get("webhook");
        this.webHookEnabled = (Boolean)webHook.get("enable");
        this.webHookUrl = (String)webHook.get("url");
        Map configChecks = (Map)this.config.get("checks");
        configChecks.forEach((key, value) -> {
            String checkName = key.substring(0, key.length() - 1);
            String checkIdentifier = key.substring(key.length() - 1);
            Class<? extends Check> checkClass = null;
            for (Class<? extends Check> check : this.checks.getChecks()) {
                CheckData checkData = check.getAnnotation(CheckData.class);
                if (!checkData.name().equals(checkName) || !checkData.identifier().equals(checkIdentifier)) continue;
                checkClass = check;
                break;
            }
            if (checkClass == null) {
                return;
            }
            Map checkMap = (Map)value;
            boolean enable = (Boolean)checkMap.get("enable");
            boolean punish = (Boolean)checkMap.get("punish");
            int punishVl = (Integer)checkMap.get("punish-vl");
            String punishCommand = (String)checkMap.get("punish-command");
            this.configDataMap.put(checkClass, new ConfigData(enable, punish, punishVl, punishCommand));
        });
        this.sender.load();
    }

    private LinkedHashMap<String, Object> merge(LinkedHashMap<String, Object> load, LinkedHashMap<String, Object> config) {
        if (load == null) {
            return config;
        }
        if (config == null) {
            return load;
        }
        config.forEach((key, value) -> {
            if (value instanceof LinkedHashMap) {
                load.put((String)key, this.merge((LinkedHashMap)load.get(key), (LinkedHashMap)value));
            } else if (!load.containsKey(key)) {
                load.put((String)key, value);
            }
        });
        LinkedHashMap<String, Object> newLoad = new LinkedHashMap<String, Object>();
        config.forEach((key, value) -> {
            if (load.containsKey(key)) {
                newLoad.put((String)key, load.get(key));
            }
        });
        load.forEach((key, value) -> {
            if (!config.containsKey(key)) {
                newLoad.put((String)key, value);
            } else if (value instanceof LinkedHashMap) {
                newLoad.put((String)key, this.merge((LinkedHashMap)value, (LinkedHashMap)config.get(key)));
            }
        });
        return newLoad;
    }

    private void propagateDefault() {
        this.config = new LinkedHashMap();
        this.config.put("prefix", "[<red>BaritoneRemover<white>] ");
        this.config.put("punishment-message", "Player <red>{player}</red> has been flagged for <red>{check}</red> (VL: {vl}/{punish-vl})");
        this.config.put("min-tps", 18.0);
        LinkedHashMap<String, Object> webHook = new LinkedHashMap<String, Object>();
        webHook.put("enable", false);
        webHook.put("url", "https://discord.com/api/webhooks/1234567890/abcdefghijklmnopqrstuvwxyz");
        this.config.put("webhook", webHook);
        LinkedHashMap configChecks = new LinkedHashMap();
        this.checks.getChecks().forEach(check -> {
            if (check.getAnnotation(CheckData.class).hidden()) {
                return;
            }
            LinkedHashMap<String, Object> checkMap = new LinkedHashMap<String, Object>();
            checkMap.put("enable", true);
            checkMap.put("punish", true);
            checkMap.put("punish-vl", 20);
            checkMap.put("punish-command", "kick %player%");
            configChecks.put(check.getAnnotation(CheckData.class).name() + check.getAnnotation(CheckData.class).identifier(), checkMap);
            this.configDataMap.put((Class<? extends Check>)check, new ConfigData(true, true, 20, "kick %player%"));
        });
        this.config.put("checks", configChecks);
    }

    public void saveConfig() {
        String configString = this.yaml.dump(this.config);
        try {
            FileWriter writer = new FileWriter(this.configFile);
            writer.write(configString);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void appendDebug(String message) {
        String formattedDate = new SimpleDateFormat("yyyy-MM-dd-").format(new Date());
        if (!this.debugFile.getName().startsWith(formattedDate)) {
            this.getCurrentDebugFile();
        }
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
        String formattedTime = dateFormat.format(date);
        message = "[" + formattedTime + "] " + message;
        try {
            FileWriter writer = new FileWriter(this.debugFile, true);
            writer.write(message + "\n");
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ConfigData getConfigData(Class<? extends Check> check) {
        return this.configDataMap.get(check);
    }

    public Component prefix() {
        return this.prefix;
    }

    public Component punishmentMessage() {
        return this.punishmentMessage;
    }

    public static ConfigManager getInstance() {
        return instance;
    }

    public FloodgateApi floodgateApi() {
        return this.floodgateApi;
    }

    public boolean webHookEnabled() {
        return this.webHookEnabled;
    }

    public String webHookUrl() {
        return this.webHookUrl;
    }

    public Sender sender() {
        return this.sender;
    }

    public double minTps() {
        return this.minTps;
    }

    public BaritoneRemover plugin() {
        return (BaritoneRemover)BaritoneRemover.getPlugin(BaritoneRemover.class);
    }
}

