/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.data;

import java.util.ArrayList;
import java.util.List;
import me.chrommob.baritoneremover.checks.inter.CheckType;
import me.chrommob.baritoneremover.data.types.PacketData;
import me.chrommob.baritoneremover.data.types.PositionData;
import me.chrommob.baritoneremover.data.types.RotationData;

public class PacketDatas {
    private final List<PacketData> packetDatas = new ArrayList<PacketData>();

    public void add(CheckType checkType, PositionData positionData, RotationData rotationData, boolean mining, boolean finishedMining, boolean placedBlock) {
        PacketData packetData = new PacketData(checkType, this.packetDatas.size(), System.currentTimeMillis(), positionData, rotationData, mining, finishedMining, placedBlock);
        this.packetDatas.add(packetData);
    }

    public PacketData getLatest() {
        if (this.packetDatas.isEmpty()) {
            return null;
        }
        return this.packetDatas.get(this.packetDatas.size() - 1);
    }

    public PacketData getLatest(CheckType checkType) {
        for (int i = this.packetDatas.size() - 1; i >= 0; --i) {
            PacketData packetData = this.packetDatas.get(i);
            if (packetData.checkType() != checkType) continue;
            return packetData;
        }
        return null;
    }

    public PacketData getLatest(CheckType checkType, CheckType checkType2) {
        for (int i = this.packetDatas.size() - 1; i >= 0; --i) {
            PacketData packetData = this.packetDatas.get(i);
            if (packetData.checkType() != checkType && packetData.checkType() != checkType2) continue;
            return packetData;
        }
        return null;
    }

    public PacketData get(int index) {
        return this.packetDatas.get(index);
    }

    public int size() {
        return this.packetDatas.size();
    }

    public int size(CheckType checkType) {
        int size = 0;
        for (PacketData packetData : this.packetDatas) {
            if (packetData.checkType() != checkType) continue;
            ++size;
        }
        return size;
    }

    public PacketData getPrevious(PacketData latest) {
        if (latest.index() == 0) {
            return null;
        }
        return this.packetDatas.get(latest.index() - 1);
    }

    public PacketData getPrevious(PacketData latest, CheckType checkType) {
        for (int i = latest.index() - 1; i >= 0; --i) {
            PacketData packetData = this.packetDatas.get(i);
            if (packetData.checkType() != checkType) continue;
            return packetData;
        }
        return null;
    }

    public PacketData getPrevious(PacketData latest, CheckType checkType, CheckType checkType2) {
        for (int i = latest.index() - 1; i >= 0; --i) {
            PacketData packetData = this.packetDatas.get(i);
            if (packetData.checkType() != checkType && packetData.checkType() != checkType2) continue;
            return packetData;
        }
        return null;
    }

    public List<PacketData> getAllType(CheckType checkType, CheckType checkType2) {
        ArrayList<PacketData> packetDataList = new ArrayList<PacketData>();
        ArrayList<PacketData> packetDatas = new ArrayList<PacketData>(this.packetDatas);
        for (PacketData packetData : packetDatas) {
            if (packetData.checkType() != checkType && packetData.checkType() != checkType2) continue;
            packetDataList.add(packetData);
        }
        return packetDataList;
    }
}

