/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.data;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import me.chrommob.baritoneremover.BaritoneRemover;
import me.chrommob.baritoneremover.checks.inter.Check;
import me.chrommob.baritoneremover.checks.inter.CheckType;
import me.chrommob.baritoneremover.checks.inter.Checks;
import me.chrommob.baritoneremover.config.ConfigManager;
import me.chrommob.baritoneremover.data.PacketDatas;
import me.chrommob.baritoneremover.data.types.PositionData;
import me.chrommob.baritoneremover.data.types.RotationData;
import me.chrommob.baritoneremover.libs.com.packetevents.util.Vector3d;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PlayerData {
    private final String name;
    private final boolean isBedrock;
    private boolean debug = false;
    private boolean isCinematic = false;
    private PacketDatas packetDataList = new PacketDatas();
    private long lastTPSCheck = System.currentTimeMillis();
    private final Set<Check> checks = new HashSet<Check>();
    private final AtomicBoolean TPS = new AtomicBoolean(false);

    public PlayerData(String name, Checks checks) {
        BaritoneRemover.scheduler().runTimer(() -> {
            long currentTime = System.currentTimeMillis();
            long difference = currentTime - this.lastTPSCheck;
            double TPS = 20.0 / ((double)difference / 1000.0);
            this.TPS.set(TPS < ConfigManager.getInstance().minTps());
            this.lastTPSCheck = currentTime;
        }, 20L, 20L);
        this.name = name;
        checks.getChecks().forEach(check -> {
            try {
                this.checks.add((Check)check.getConstructor(PlayerData.class).newInstance(this));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.isBedrock = ConfigManager.getInstance().floodgateApi() != null && ConfigManager.getInstance().floodgateApi().isFloodgatePlayer(Bukkit.getPlayer((String)name).getUniqueId());
    }

    public void updatePosition(Vector3d location) {
        this.packetDataList.add(CheckType.POSITION, new PositionData(location), null, false, false, false);
        this.runChecks(CheckType.POSITION);
        this.runChecks(CheckType.ANY);
    }

    public void updateRotation(float pitch, float yaw) {
        this.packetDataList.add(CheckType.ROTATION, null, new RotationData(pitch, yaw), false, false, false);
        this.runChecks(CheckType.ROTATION);
        this.runChecks(CheckType.ANY);
    }

    public void updateBoth(Vector3d position, float pitch, float yaw) {
        this.packetDataList.add(CheckType.FLYING, new PositionData(position), new RotationData(pitch, yaw), false, false, false);
        this.runChecks(CheckType.FLYING);
        this.runChecks(CheckType.ANY);
    }

    public void startMining() {
        this.packetDataList.add(CheckType.MINING, null, null, true, false, false);
        this.runChecks(CheckType.MINING);
        this.runChecks(CheckType.ANY);
    }

    public void finishMining() {
        this.packetDataList.add(CheckType.MINED, null, null, false, true, false);
        this.runChecks(CheckType.MINED);
        this.runChecks(CheckType.ANY);
    }

    public void blockPlace() {
        this.packetDataList.add(CheckType.PLACE, null, null, false, false, true);
        BaritoneRemover.scheduler().runAsync(() -> {
            this.runChecks(CheckType.PLACE);
            this.runChecks(CheckType.ANY);
        });
    }

    public void debug() {
        this.debug = !this.debug;
    }

    public String name() {
        return this.name;
    }

    public void runChecks(CheckType updateType) {
        if (updateType == CheckType.NONE) {
            return;
        }
        if (this.TPS.get()) {
            return;
        }
        Player player = Bukkit.getPlayer((String)this.name);
        if (player != null && player.hasPermission("br.bypass")) {
            return;
        }
        this.checks.forEach(check -> {
            if (check.checkType() != updateType) {
                return;
            }
            check.run();
        });
        if (this.packetDataList.size() == 0) {
            return;
        }
        if (this.packetDataList.size() % 100 == 0) {
            this.checks.forEach(check -> {
                if (check.checkType() == CheckType.AGGREGATE) {
                    check.run();
                }
            });
        }
        if (this.packetDataList.size() > 1000) {
            this.packetDataList = new PacketDatas();
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public boolean isBedrock() {
        return this.isBedrock;
    }

    public PacketDatas packetDataList() {
        return this.packetDataList;
    }

    public Set<Check> checks() {
        return this.checks;
    }

    public void setCinematic(boolean cinematic) {
        this.isCinematic = cinematic;
    }

    public boolean isCinematic() {
        return this.isCinematic;
    }
}

