/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.data;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import me.chrommob.baritoneremover.BaritoneRemover;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class Scheduler {
    private BaritoneRemover plugin;
    private static final boolean isFolia;
    private static final MethodHandle execute;
    private static final MethodHandle runAtFixedRate;
    private final Map<Integer, Object> tasks = new HashMap<Integer, Object>();
    private static final Object globalRegionScheduler;

    public Scheduler(BaritoneRemover plugin) {
        this.plugin = plugin;
    }

    public void runAsync(Runnable runnable) {
        if (isFolia) {
            try {
                execute.invoke(globalRegionScheduler, this.plugin, runnable);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, runnable);
        }
    }

    public void run(Runnable runnable) {
        if (isFolia) {
            try {
                execute.invoke(globalRegionScheduler, this.plugin, runnable);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, runnable);
        }
    }

    public int runTimer(Runnable runnable, long delay, long period) {
        if (isFolia) {
            try {
                if (delay <= 0L) {
                    delay = 1L;
                }
                Object res = runAtFixedRate.invoke(globalRegionScheduler, this.plugin, task -> runnable.run(), delay, period);
                Random random = new Random();
                int id = random.nextInt();
                this.tasks.put(id, res);
                return id;
            }
            catch (Throwable e) {
                e.printStackTrace();
                return -1;
            }
        }
        return Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, runnable, delay, period).getTaskId();
    }

    public void cancel(int id) {
        if (id == -1) {
            return;
        }
        if (isFolia) {
            try {
                this.tasks.get(id).getClass().getMethod("cancel", new Class[0]).invoke(this.tasks.get(id), new Object[0]);
                this.tasks.remove(id);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        } else {
            Bukkit.getScheduler().cancelTask(id);
        }
    }

    static {
        boolean isFolia1;
        MethodHandle execute1 = null;
        MethodHandle runAtFixedRate1 = null;
        Object globalRegionScheduler1 = null;
        try {
            Class.forName("io.papermc.paper.threadedregions.RegionizedServer");
            isFolia1 = true;
        }
        catch (ClassNotFoundException e) {
            isFolia1 = false;
        }
        isFolia = isFolia1;
        if (isFolia) {
            Class serverClass = Bukkit.getServer().getClass();
            Object globalRegionScheduler = null;
            try {
                for (Method method : serverClass.getMethods()) {
                    if (!method.getName().equals("getGlobalRegionScheduler")) continue;
                    globalRegionScheduler = method.invoke((Object)Bukkit.getServer(), new Object[0]);
                    break;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            globalRegionScheduler1 = globalRegionScheduler;
            try {
                MethodHandles.Lookup lookup = MethodHandles.lookup();
                for (Method method : globalRegionScheduler.getClass().getMethods()) {
                    if (method.getName().equals("execute")) {
                        execute1 = lookup.unreflect(method);
                    }
                    if (method.getName().equals("runAtFixedRate")) {
                        runAtFixedRate1 = lookup.unreflect(method);
                    }
                    if (execute1 == null || runAtFixedRate1 == null) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        globalRegionScheduler = globalRegionScheduler1;
        execute = execute1;
        runAtFixedRate = runAtFixedRate1;
    }
}

