/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.data.types;

import java.util.Objects;
import me.chrommob.baritoneremover.checks.inter.CheckType;
import me.chrommob.baritoneremover.data.types.PositionData;
import me.chrommob.baritoneremover.data.types.RotationData;

public final class PacketData {
    private final CheckType checkType;
    private final int index;
    private final long timeStamp;
    private final PositionData positionData;
    private final RotationData rotationData;
    private final boolean mining;
    private final boolean finishedMining;
    private final boolean placedBlock;

    public PacketData(CheckType checkType, int index, long timeStamp, PositionData positionData, RotationData rotationData, boolean mining, boolean finishedMining, boolean placedBlock) {
        this.checkType = checkType;
        this.index = index;
        this.timeStamp = timeStamp;
        this.positionData = positionData;
        this.rotationData = rotationData;
        this.mining = mining;
        this.finishedMining = finishedMining;
        this.placedBlock = placedBlock;
    }

    public int index() {
        return this.index;
    }

    public long timeStamp() {
        return this.timeStamp;
    }

    public PositionData positionData() {
        return this.positionData;
    }

    public RotationData rotationData() {
        return this.rotationData;
    }

    public boolean mining() {
        return this.mining;
    }

    public boolean finishedMining() {
        return this.finishedMining;
    }

    public boolean placedBlock() {
        return this.placedBlock;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PacketData that = (PacketData)obj;
        return this.index == that.index && this.timeStamp == that.timeStamp && Objects.equals(this.positionData, that.positionData) && Objects.equals(this.rotationData, that.rotationData) && this.mining == that.mining && this.finishedMining == that.finishedMining && this.placedBlock == that.placedBlock;
    }

    public int hashCode() {
        return Objects.hash(this.index, this.timeStamp, this.positionData, this.rotationData, this.mining, this.finishedMining);
    }

    public String toString() {
        return "PacketData[index=" + this.index + ", timeStamp=" + this.timeStamp + ", positionData=" + this.positionData + ", rotationData=" + this.rotationData + ", mining=" + this.mining + ", finishedMining=" + this.finishedMining + ']';
    }

    public double distance(PacketData other) {
        return this.positionData.distance(other.positionData().location());
    }

    public float distanceRotation(PacketData other) {
        return this.rotationData.distance(other.rotationData());
    }

    public float differencePitch(PacketData other) {
        return this.rotationData.differencePitch(other.rotationData());
    }

    public float differenceYaw(PacketData other) {
        return this.rotationData.differenceYaw(other.rotationData());
    }

    public CheckType checkType() {
        return this.checkType;
    }
}

