/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.data.types;

import java.util.Objects;
import me.chrommob.baritoneremover.libs.com.packetevents.util.Vector3d;

public class PositionData {
    private final Vector3d location;
    private final double x;
    private final double y;
    private final double z;

    public PositionData(Vector3d location) {
        this.location = location;
        this.x = location.x;
        this.y = location.y;
        this.z = location.z;
    }

    public double distance(Vector3d other) {
        return this.location.distance(other);
    }

    public Vector3d location() {
        return this.location;
    }

    public double differenceX(PositionData positionData) {
        return Math.abs(this.x - positionData.x);
    }

    public double differenceY(PositionData positionData) {
        return Math.abs(this.y - positionData.y);
    }

    public double differenceZ(PositionData positionData) {
        return Math.abs(this.z - positionData.z);
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        PositionData that = (PositionData)obj;
        return Double.doubleToLongBits(this.x) == Double.doubleToLongBits(that.x) && Double.doubleToLongBits(this.y) == Double.doubleToLongBits(that.y) && Double.doubleToLongBits(this.z) == Double.doubleToLongBits(that.z);
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public String toString() {
        return "PositionData[x=" + this.x + ", y=" + this.y + ", z=" + this.z + ']';
    }
}

