/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.data.types;

import java.util.Objects;

public final class RotationData {
    private final float pitch;
    private final float yaw;

    public RotationData(float pitch, float yaw) {
        this.pitch = pitch;
        this.yaw = yaw;
    }

    public float pitch() {
        return this.pitch;
    }

    public float yaw() {
        return this.yaw;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RotationData that = (RotationData)obj;
        return Float.floatToIntBits(this.pitch) == Float.floatToIntBits(that.pitch) && Float.floatToIntBits(this.yaw) == Float.floatToIntBits(that.yaw);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.pitch), Float.valueOf(this.yaw));
    }

    public String toString() {
        return "RotationData[pitch=" + this.pitch + ", yaw=" + this.yaw + ']';
    }

    public float distance(RotationData other) {
        return Math.abs(this.pitch - other.pitch()) + Math.abs(this.yaw - other.yaw());
    }

    public float differencePitch(RotationData other) {
        return Math.abs(this.pitch - other.pitch());
    }

    public float differenceYaw(RotationData other) {
        return Math.abs(this.yaw - other.yaw());
    }
}

