/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.libs.com.packetevents.protocol.chat.clickevent;

import me.chrommob.baritoneremover.libs.com.packetevents.manager.server.ServerVersion;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.chat.clickevent.ClickEvent;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.chat.clickevent.ClickEventAction;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.chat.clickevent.ClickEventActions;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBTCompound;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBTString;
import me.chrommob.baritoneremover.libs.com.packetevents.wrapper.PacketWrapper;
import org.jspecify.annotations.NullMarked;

@NullMarked
public class OpenUrlClickEvent
implements ClickEvent {
    private final String url;

    public OpenUrlClickEvent(String url) {
        this.url = url;
    }

    public static OpenUrlClickEvent decode(NBTCompound compound, PacketWrapper<?> wrapper) {
        boolean v1215 = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5);
        String url = compound.getStringTagValueOrThrow(v1215 ? "url" : "value");
        return new OpenUrlClickEvent(url);
    }

    public static void encode(NBTCompound compound, PacketWrapper<?> wrapper, OpenUrlClickEvent clickEvent) {
        boolean v1215 = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5);
        compound.setTag(v1215 ? "url" : "value", new NBTString(clickEvent.url));
    }

    @Override
    public ClickEventAction<?> getAction() {
        return ClickEventActions.OPEN_URL;
    }

    @Override
    public me.chrommob.baritoneremover.libs.kyori.adventure.text.event.ClickEvent asAdventure() {
        return me.chrommob.baritoneremover.libs.kyori.adventure.text.event.ClickEvent.openUrl(this.url);
    }

    public String getUrl() {
        return this.url;
    }
}

