/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.libs.com.packetevents.protocol.entity.cat;

import me.chrommob.baritoneremover.libs.com.packetevents.protocol.entity.cat.CatVariants;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.entity.cat.StaticCatVariant;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.mapper.CopyableEntity;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.mapper.DeepComparableEntity;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.mapper.MappedEntity;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBT;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBTCompound;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBTString;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.player.ClientVersion;
import me.chrommob.baritoneremover.libs.com.packetevents.resources.ResourceLocation;
import me.chrommob.baritoneremover.libs.com.packetevents.util.mappings.TypesBuilderData;
import me.chrommob.baritoneremover.libs.com.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface CatVariant
extends MappedEntity,
CopyableEntity<CatVariant>,
DeepComparableEntity {
    public ResourceLocation getAssetId();

    public static CatVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(CatVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, CatVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static CatVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticCatVariant(data, assetId);
    }

    public static NBT encode(CatVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }
}

