/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.libs.com.packetevents.protocol.entity.chicken;

import me.chrommob.baritoneremover.libs.com.packetevents.protocol.entity.chicken.ChickenVariants;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.entity.chicken.StaticChickenVariant;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.mapper.CopyableEntity;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.mapper.DeepComparableEntity;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.mapper.MappedEntity;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBT;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBTCompound;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBTString;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.player.ClientVersion;
import me.chrommob.baritoneremover.libs.com.packetevents.resources.ResourceLocation;
import me.chrommob.baritoneremover.libs.com.packetevents.util.adventure.AdventureIndexUtil;
import me.chrommob.baritoneremover.libs.com.packetevents.util.mappings.TypesBuilderData;
import me.chrommob.baritoneremover.libs.com.packetevents.wrapper.PacketWrapper;
import me.chrommob.baritoneremover.libs.kyori.adventure.util.Index;
import org.jetbrains.annotations.Nullable;

public interface ChickenVariant
extends MappedEntity,
CopyableEntity<ChickenVariant>,
DeepComparableEntity {
    public ModelType getModelType();

    public ResourceLocation getAssetId();

    public static ChickenVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(ChickenVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, ChickenVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static ChickenVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        String modelTypeString = compound.getStringTagValueOrNull("model");
        ModelType modelType = modelTypeString != null ? ModelType.getByName(modelTypeString) : ModelType.NORMAL;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticChickenVariant(data, modelType, assetId);
    }

    public static NBT encode(ChickenVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("model", new NBTString(variant.getModelType().getName()));
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }

    public static enum ModelType {
        NORMAL("normal"),
        COLD("cold");

        private static final Index<String, ModelType> NAME_INDEX;
        private final String name;

        private ModelType(String name) {
            this.name = name;
        }

        public static ModelType getByName(String name) {
            return AdventureIndexUtil.indexValueOrThrow(NAME_INDEX, name);
        }

        public String getName() {
            return this.name;
        }

        static {
            NAME_INDEX = Index.create(ModelType.class, ModelType::getName);
        }
    }
}

