/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.libs.com.packetevents.protocol.entity.frog;

import me.chrommob.baritoneremover.libs.com.packetevents.protocol.entity.frog.FrogVariants;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.entity.frog.StaticFrogVariant;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.mapper.CopyableEntity;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.mapper.DeepComparableEntity;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.mapper.MappedEntity;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBT;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBTCompound;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBTString;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.player.ClientVersion;
import me.chrommob.baritoneremover.libs.com.packetevents.resources.ResourceLocation;
import me.chrommob.baritoneremover.libs.com.packetevents.util.mappings.TypesBuilderData;
import me.chrommob.baritoneremover.libs.com.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface FrogVariant
extends MappedEntity,
CopyableEntity<FrogVariant>,
DeepComparableEntity {
    public ResourceLocation getAssetId();

    public static FrogVariant read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntity(FrogVariants.getRegistry());
    }

    public static void write(PacketWrapper<?> wrapper, FrogVariant variant) {
        wrapper.writeMappedEntity(variant);
    }

    public static FrogVariant decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        return new StaticFrogVariant(data, assetId);
    }

    public static NBT encode(FrogVariant variant, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("asset_id", new NBTString(variant.getAssetId().toString()));
        return compound;
    }
}

