/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.libs.com.packetevents.protocol.item.banner;

import me.chrommob.baritoneremover.libs.com.packetevents.protocol.item.banner.StaticBannerPattern;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.mapper.CopyableEntity;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.mapper.DeepComparableEntity;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.mapper.MappedEntity;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBT;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBTCompound;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBTString;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.player.ClientVersion;
import me.chrommob.baritoneremover.libs.com.packetevents.resources.ResourceLocation;
import me.chrommob.baritoneremover.libs.com.packetevents.util.mappings.TypesBuilderData;
import me.chrommob.baritoneremover.libs.com.packetevents.wrapper.PacketWrapper;
import org.jetbrains.annotations.Nullable;

public interface BannerPattern
extends MappedEntity,
CopyableEntity<BannerPattern>,
DeepComparableEntity {
    public ResourceLocation getAssetId();

    public String getTranslationKey();

    public static BannerPattern readDirect(PacketWrapper<?> wrapper) {
        ResourceLocation assetId = wrapper.readIdentifier();
        String translationKey = wrapper.readString();
        return new StaticBannerPattern(assetId, translationKey);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, BannerPattern pattern) {
        wrapper.writeIdentifier(pattern.getAssetId());
        wrapper.writeString(pattern.getTranslationKey());
    }

    public static BannerPattern decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        String translationKey = compound.getStringTagValueOrThrow("translation_key");
        return new StaticBannerPattern(data, assetId, translationKey);
    }

    public static NBT encode(BannerPattern bannerPattern, ClientVersion version) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("asset_id", new NBTString(bannerPattern.getAssetId().toString()));
        compound.setTag("translation_key", new NBTString(bannerPattern.getTranslationKey()));
        return compound;
    }
}

