/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.libs.com.packetevents.protocol.item.trimpattern;

import me.chrommob.baritoneremover.libs.com.packetevents.manager.server.ServerVersion;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.item.trimpattern.StaticTrimPattern;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.item.trimpattern.TrimPatterns;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.item.type.ItemType;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.item.type.ItemTypes;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.mapper.CopyableEntity;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.mapper.DeepComparableEntity;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.mapper.MappedEntity;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBT;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBTByte;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBTCompound;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBTString;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.player.ClientVersion;
import me.chrommob.baritoneremover.libs.com.packetevents.resources.ResourceLocation;
import me.chrommob.baritoneremover.libs.com.packetevents.util.mappings.TypesBuilderData;
import me.chrommob.baritoneremover.libs.com.packetevents.wrapper.PacketWrapper;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface TrimPattern
extends MappedEntity,
CopyableEntity<TrimPattern>,
DeepComparableEntity {
    public ResourceLocation getAssetId();

    @ApiStatus.Obsolete
    public ItemType getTemplateItem();

    public Component getDescription();

    public boolean isDecal();

    public static TrimPattern read(PacketWrapper<?> wrapper) {
        return wrapper.readMappedEntityOrDirect(TrimPatterns.getRegistry(), TrimPattern::readDirect);
    }

    public static TrimPattern readDirect(PacketWrapper<?> wrapper) {
        ResourceLocation assetId = wrapper.readIdentifier();
        ItemType templateItem = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5) ? null : wrapper.readMappedEntity(ItemTypes::getById);
        Component description = wrapper.readComponent();
        boolean decal = wrapper.readBoolean();
        return new StaticTrimPattern(assetId, templateItem, description, decal);
    }

    public static void write(PacketWrapper<?> wrapper, TrimPattern pattern) {
        wrapper.writeMappedEntityOrDirect(pattern, TrimPattern::writeDirect);
    }

    public static void writeDirect(PacketWrapper<?> wrapper, TrimPattern pattern) {
        wrapper.writeIdentifier(pattern.getAssetId());
        if (wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_21_5)) {
            wrapper.writeMappedEntity(pattern.getTemplateItem());
        }
        wrapper.writeComponent(pattern.getDescription());
        wrapper.writeBoolean(pattern.isDecal());
    }

    @Deprecated
    public static TrimPattern decode(NBT nbt, ClientVersion version, @Nullable TypesBuilderData data) {
        return TrimPattern.decode(nbt, PacketWrapper.createDummyWrapper(version), data);
    }

    public static TrimPattern decode(NBT nbt, PacketWrapper<?> wrapper, @Nullable TypesBuilderData data) {
        NBTCompound compound = (NBTCompound)nbt;
        ResourceLocation assetId = new ResourceLocation(compound.getStringTagValueOrThrow("asset_id"));
        ItemType templateItem = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_21_5) ? null : ItemTypes.getByName(compound.getStringTagValueOrThrow("template_item"));
        Component description = compound.getOrThrow("description", wrapper.getSerializers(), wrapper);
        boolean decal = wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_2) && compound.getBoolean("decal");
        return new StaticTrimPattern(data, assetId, templateItem, description, decal);
    }

    @Deprecated
    public static NBT encode(TrimPattern pattern, ClientVersion version) {
        return TrimPattern.encode(PacketWrapper.createDummyWrapper(version), pattern);
    }

    public static NBT encode(PacketWrapper<?> wrapper, TrimPattern pattern) {
        NBTCompound compound = new NBTCompound();
        compound.setTag("asset_id", new NBTString(pattern.getAssetId().toString()));
        if (wrapper.getServerVersion().isOlderThan(ServerVersion.V_1_21_5)) {
            compound.setTag("template_item", new NBTString(pattern.getTemplateItem().getName().toString()));
        }
        compound.set("description", pattern.getDescription(), wrapper.getSerializers(), wrapper);
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_20_2)) {
            compound.setTag("decal", new NBTByte(pattern.isDecal()));
        }
        return compound;
    }
}

