/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt;

import me.chrommob.baritoneremover.libs.com.packetevents.netty.buffer.ByteBufHelper;
import org.jetbrains.annotations.NotNull;

public interface NBTLimiter {
    public static final int DEFAULT_MAX_SIZE = 0x200000;

    public static NBTLimiter noop() {
        return new NBTLimiter(){

            @Override
            public void increment(int amount) {
            }

            @Override
            public void checkReadability(int length) {
            }
        };
    }

    public static NBTLimiter forBuffer(@NotNull Object byteBuf) {
        return NBTLimiter.forBuffer(byteBuf, 0x200000);
    }

    public static NBTLimiter forBuffer(final @NotNull Object byteBuf, final int max) {
        return new NBTLimiter(){
            private int bytes;

            @Override
            public void increment(int amount) {
                this.bytes += amount;
                if (this.bytes > max) {
                    throw new IllegalArgumentException("NBT size limit reached (" + this.bytes + "/" + max + ")");
                }
            }

            @Override
            public void checkReadability(int length) {
                if (length > ByteBufHelper.readableBytes(byteBuf)) {
                    throw new IllegalArgumentException("Length is too large: " + length + ", readable: " + ByteBufHelper.readableBytes(byteBuf));
                }
            }
        };
    }

    public void increment(int var1);

    public void checkReadability(int var1);
}

