/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.libs.com.packetevents.protocol.particle.data;

import me.chrommob.baritoneremover.libs.com.packetevents.manager.server.ServerVersion;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.item.ItemStack;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.item.type.ItemType;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.item.type.ItemTypes;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBTCompound;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.particle.data.LegacyConvertible;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.particle.data.LegacyParticleData;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.particle.data.ParticleData;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.player.ClientVersion;
import me.chrommob.baritoneremover.libs.com.packetevents.wrapper.PacketWrapper;

public class ParticleItemStackData
extends ParticleData
implements LegacyConvertible {
    private ItemStack itemStack;

    public ParticleItemStackData(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public static ParticleItemStackData read(PacketWrapper<?> wrapper) {
        if (wrapper.getServerVersion().isNewerThanOrEquals(ServerVersion.V_1_13)) {
            return new ParticleItemStackData(wrapper.readItemStack());
        }
        return new ParticleItemStackData(ItemStack.builder().type((ItemType)ItemTypes.getRegistry().getByIdOrThrow(wrapper.getClientVersion(), wrapper.readVarInt())).wrapper(wrapper).build());
    }

    public static void write(PacketWrapper<?> wrapper, ParticleItemStackData data) {
        wrapper.writeItemStack(data.getItemStack());
    }

    public static ParticleItemStackData decode(NBTCompound compound, ClientVersion version) {
        String key = version.isNewerThanOrEquals(ClientVersion.V_1_20_5) ? "item" : "value";
        ItemStack stack = ItemStack.decode(compound.getTagOrThrow(key), version);
        return new ParticleItemStackData(stack);
    }

    public static void encode(ParticleItemStackData data, ClientVersion version, NBTCompound compound) {
        String key = version.isNewerThanOrEquals(ClientVersion.V_1_20_5) ? "item" : "value";
        compound.setTag(key, ItemStack.encodeForParticle(data.itemStack, version));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public LegacyParticleData toLegacy(ClientVersion version) {
        return LegacyParticleData.ofTwo(this.itemStack.getType().getId(version), this.itemStack.getLegacyData());
    }
}

