/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.libs.com.packetevents.protocol.stats;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.chrommob.baritoneremover.libs.com.packetevents.PacketEvents;
import me.chrommob.baritoneremover.libs.com.packetevents.manager.server.ServerVersion;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBT;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.NBTString;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.nbt.serializer.SequentialNBTReader;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.stats.Statistic;
import me.chrommob.baritoneremover.libs.com.packetevents.util.adventure.AdventureSerializer;
import me.chrommob.baritoneremover.libs.com.packetevents.util.mappings.MappingHelper;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.Component;

public class Statistics {
    private static final Map<String, Statistic> STATISTIC_MAP = new HashMap<String, Statistic>();

    public static Statistic getById(String id) {
        return STATISTIC_MAP.get(id);
    }

    static {
        ServerVersion version = PacketEvents.getAPI().getServerManager().getVersion();
        if (version.isOlderThan(ServerVersion.V_1_12_2)) {
            try (SequentialNBTReader.Compound rootMapping = MappingHelper.decompress("mappings/data/statistics");){
                rootMapping.skipOne();
                SequentialNBTReader.Compound mapping = (SequentialNBTReader.Compound)rootMapping.next().getValue();
                if (version.isOlderThanOrEquals(ServerVersion.V_1_8_3)) {
                    mapping.skipOne();
                }
                SequentialNBTReader.Compound toLoad = (SequentialNBTReader.Compound)mapping.next().getValue();
                for (final Map.Entry<String, NBT> entry : toLoad) {
                    final String value = ((NBTString)entry.getValue()).getValue();
                    Statistic statistic = new Statistic(){
                        private Component cachedDisplay;

                        @Override
                        public String getId() {
                            return (String)entry.getKey();
                        }

                        @Override
                        public Component display() {
                            if (this.cachedDisplay == null) {
                                this.cachedDisplay = AdventureSerializer.serializer().fromJson(value);
                            }
                            return this.cachedDisplay;
                        }

                        public boolean equals(Object obj) {
                            if (obj instanceof Statistic) {
                                return ((Statistic)obj).getId().equals(this.getId());
                            }
                            return false;
                        }
                    };
                    STATISTIC_MAP.put(entry.getKey(), statistic);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot load statistics mappings", e);
            }
        }
    }
}

