/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.libs.com.packetevents.protocol.world.chunk.palette;

import java.util.HashMap;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.stream.NetStreamInput;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.world.chunk.palette.Palette;
import me.chrommob.baritoneremover.libs.com.packetevents.wrapper.PacketWrapper;

public class MapPalette
implements Palette {
    private final int bits;
    private final int[] idToState;
    private final HashMap<Object, Integer> stateToId = new HashMap();
    private int nextId = 0;

    public MapPalette(int bitsPerEntry) {
        this.bits = bitsPerEntry;
        this.idToState = new int[1 << bitsPerEntry];
    }

    @Deprecated
    public MapPalette(int bitsPerEntry, NetStreamInput in) {
        this(bitsPerEntry);
        int paletteLength = in.readVarInt();
        for (int i = 0; i < paletteLength; ++i) {
            int state;
            this.idToState[i] = state = in.readVarInt();
            this.stateToId.putIfAbsent(state, i);
        }
        this.nextId = paletteLength;
    }

    public MapPalette(int bitsPerEntry, PacketWrapper<?> wrapper) {
        this(bitsPerEntry);
        int paletteLength = wrapper.readVarInt();
        for (int i = 0; i < paletteLength; ++i) {
            int state;
            this.idToState[i] = state = wrapper.readVarInt();
            this.stateToId.putIfAbsent(state, i);
        }
        this.nextId = paletteLength;
    }

    @Override
    public int size() {
        return this.nextId;
    }

    @Override
    public int stateToId(int state) {
        Integer id = this.stateToId.get(state);
        if (id == null && this.size() < this.idToState.length) {
            id = this.nextId++;
            this.idToState[id.intValue()] = state;
            this.stateToId.put(state, id);
        }
        if (id != null) {
            return id;
        }
        return -1;
    }

    @Override
    public int idToState(int id) {
        if (id >= 0 && id < this.size()) {
            return this.idToState[id];
        }
        return 0;
    }

    @Override
    public int getBits() {
        return this.bits;
    }
}

