/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.libs.com.packetevents.util;

import java.util.UUID;
import me.chrommob.baritoneremover.libs.com.packetevents.PacketEvents;
import me.chrommob.baritoneremover.libs.com.packetevents.event.PacketReceiveEvent;
import me.chrommob.baritoneremover.libs.com.packetevents.event.PacketSendEvent;
import me.chrommob.baritoneremover.libs.com.packetevents.event.ProtocolPacketEvent;
import me.chrommob.baritoneremover.libs.com.packetevents.event.UserDisconnectEvent;
import me.chrommob.baritoneremover.libs.com.packetevents.manager.protocol.ProtocolManager;
import me.chrommob.baritoneremover.libs.com.packetevents.netty.buffer.ByteBufHelper;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.PacketSide;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.player.User;
import me.chrommob.baritoneremover.libs.com.packetevents.util.EventCreationUtil;
import org.jetbrains.annotations.Nullable;

public final class PacketEventsImplHelper {
    private PacketEventsImplHelper() {
    }

    @Nullable
    public static ProtocolPacketEvent handlePacket(Object channel, User user, Object player, Object buffer, boolean autoProtocolTranslation, PacketSide side) throws Exception {
        if (side == PacketSide.SERVER) {
            return PacketEventsImplHelper.handleClientBoundPacket(channel, user, player, buffer, autoProtocolTranslation);
        }
        return PacketEventsImplHelper.handleServerBoundPacket(channel, user, player, buffer, autoProtocolTranslation);
    }

    @Nullable
    public static PacketSendEvent handleClientBoundPacket(Object channel, User user, Object player, Object buffer, boolean autoProtocolTranslation) throws Exception {
        if (!ByteBufHelper.isReadable(buffer)) {
            return null;
        }
        int preProcessIndex = ByteBufHelper.readerIndex(buffer);
        PacketSendEvent packetSendEvent = EventCreationUtil.createSendEvent(channel, user, player, buffer, autoProtocolTranslation);
        int processIndex = ByteBufHelper.readerIndex(buffer);
        PacketEvents.getAPI().getEventManager().callEvent(packetSendEvent, () -> ByteBufHelper.readerIndex(buffer, processIndex));
        if (!packetSendEvent.isCancelled()) {
            if (packetSendEvent.getLastUsedWrapper() != null) {
                ByteBufHelper.clear(buffer);
                packetSendEvent.getLastUsedWrapper().writeVarInt(packetSendEvent.getPacketId());
                packetSendEvent.getLastUsedWrapper().write();
            } else {
                ByteBufHelper.readerIndex(buffer, preProcessIndex);
            }
        } else {
            ByteBufHelper.clear(buffer);
        }
        if (packetSendEvent.hasPostTasks()) {
            for (Runnable task : packetSendEvent.getPostTasks()) {
                task.run();
            }
        }
        return packetSendEvent;
    }

    @Nullable
    public static PacketReceiveEvent handleServerBoundPacket(Object channel, User user, Object player, Object buffer, boolean autoProtocolTranslation) throws Exception {
        if (!ByteBufHelper.isReadable(buffer)) {
            return null;
        }
        int preProcessIndex = ByteBufHelper.readerIndex(buffer);
        PacketReceiveEvent packetReceiveEvent = EventCreationUtil.createReceiveEvent(channel, user, player, buffer, autoProtocolTranslation);
        int processIndex = ByteBufHelper.readerIndex(buffer);
        PacketEvents.getAPI().getEventManager().callEvent(packetReceiveEvent, () -> ByteBufHelper.readerIndex(buffer, processIndex));
        if (!packetReceiveEvent.isCancelled()) {
            if (packetReceiveEvent.getLastUsedWrapper() != null) {
                ByteBufHelper.clear(buffer);
                packetReceiveEvent.getLastUsedWrapper().writeVarInt(packetReceiveEvent.getPacketId());
                packetReceiveEvent.getLastUsedWrapper().write();
            } else {
                ByteBufHelper.readerIndex(buffer, preProcessIndex);
            }
        } else {
            ByteBufHelper.clear(buffer);
        }
        if (packetReceiveEvent.hasPostTasks()) {
            for (Runnable task : packetReceiveEvent.getPostTasks()) {
                task.run();
            }
        }
        return packetReceiveEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleDisconnection(Object channel, @Nullable UUID uuid) {
        Object object = channel;
        synchronized (object) {
            ProtocolManager protocolManager = PacketEvents.getAPI().getProtocolManager();
            User user = protocolManager.getUser(channel);
            if (user != null) {
                UserDisconnectEvent disconnectEvent = new UserDisconnectEvent(user);
                PacketEvents.getAPI().getEventManager().callEvent(disconnectEvent);
                protocolManager.removeUser(user.getChannel());
            }
            if (uuid == null) {
                protocolManager.removeChannel(channel);
            } else {
                protocolManager.removeChannelById(uuid);
            }
        }
    }
}

