/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.libs.com.packetevents.wrapper.play.client;

import me.chrommob.baritoneremover.libs.com.packetevents.event.PacketReceiveEvent;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.packettype.PacketType;
import me.chrommob.baritoneremover.libs.com.packetevents.wrapper.PacketWrapper;

public class WrapperPlayClientPlayerInput
extends PacketWrapper<WrapperPlayClientPlayerInput> {
    private boolean forward;
    private boolean backward;
    private boolean left;
    private boolean right;
    private boolean jump;
    private boolean shift;
    private boolean sprint;

    public WrapperPlayClientPlayerInput(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientPlayerInput(boolean forward, boolean backward, boolean left, boolean right, boolean jump, boolean shift, boolean sprint) {
        super(PacketType.Play.Client.PLAYER_INPUT);
        this.forward = forward;
        this.backward = backward;
        this.left = left;
        this.right = right;
        this.jump = jump;
        this.shift = shift;
        this.sprint = sprint;
    }

    @Override
    public void read() {
        byte flags = this.readByte();
        this.forward = (flags & 1) != 0;
        this.backward = (flags & 2) != 0;
        this.left = (flags & 4) != 0;
        this.right = (flags & 8) != 0;
        this.jump = (flags & 0x10) != 0;
        this.shift = (flags & 0x20) != 0;
        this.sprint = (flags & 0x40) != 0;
    }

    @Override
    public void write() {
        byte flags = 0;
        flags = (byte)(flags | (this.forward ? 1 : 0));
        flags = (byte)(flags | (this.backward ? 2 : 0));
        flags = (byte)(flags | (this.left ? 4 : 0));
        flags = (byte)(flags | (this.right ? 8 : 0));
        flags = (byte)(flags | (this.jump ? 16 : 0));
        flags = (byte)(flags | (this.shift ? 32 : 0));
        flags = (byte)(flags | (this.sprint ? 64 : 0));
        this.writeByte(flags);
    }

    @Override
    public void copy(WrapperPlayClientPlayerInput wrapper) {
        this.forward = wrapper.forward;
        this.backward = wrapper.backward;
        this.left = wrapper.left;
        this.right = wrapper.right;
        this.jump = wrapper.jump;
        this.shift = wrapper.shift;
        this.sprint = wrapper.sprint;
    }

    public boolean isForward() {
        return this.forward;
    }

    public void setForward(boolean forward) {
        this.forward = forward;
    }

    public boolean isBackward() {
        return this.backward;
    }

    public void setBackward(boolean backward) {
        this.backward = backward;
    }

    public boolean isLeft() {
        return this.left;
    }

    public void setLeft(boolean left) {
        this.left = left;
    }

    public boolean isRight() {
        return this.right;
    }

    public void setRight(boolean right) {
        this.right = right;
    }

    public boolean isJump() {
        return this.jump;
    }

    public void setJump(boolean jump) {
        this.jump = jump;
    }

    public boolean isShift() {
        return this.shift;
    }

    public void setShift(boolean shift) {
        this.shift = shift;
    }

    public boolean isSprint() {
        return this.sprint;
    }

    public void setSprint(boolean sprint) {
        this.sprint = sprint;
    }
}

