/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.libs.com.packetevents.wrapper.play.client;

import me.chrommob.baritoneremover.libs.com.packetevents.event.PacketReceiveEvent;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.packettype.PacketType;
import me.chrommob.baritoneremover.libs.com.packetevents.util.Vector3i;
import me.chrommob.baritoneremover.libs.com.packetevents.wrapper.PacketWrapper;

public class WrapperPlayClientUpdateCommandBlock
extends PacketWrapper<WrapperPlayClientUpdateCommandBlock> {
    private static final int FLAG_TRACK_OUTPUT = 1;
    private static final int FLAG_CONDITIONAL = 2;
    private static final int FLAG_AUTOMATIC = 4;
    private Vector3i position;
    private String command;
    private CommandBlockMode mode;
    private boolean doesTrackOutput;
    private boolean conditional;
    private boolean automatic;
    private short flags;

    public WrapperPlayClientUpdateCommandBlock(PacketReceiveEvent event) {
        super(event);
    }

    public WrapperPlayClientUpdateCommandBlock(Vector3i position, String command, CommandBlockMode mode, boolean doesTrackOutput, boolean conditional, boolean automatic) {
        super(PacketType.Play.Client.UPDATE_COMMAND_BLOCK);
        this.position = position;
        this.command = command;
        this.mode = mode;
        this.doesTrackOutput = doesTrackOutput;
        this.conditional = conditional;
        this.automatic = automatic;
    }

    @Override
    public void read() {
        this.position = new Vector3i(this.readLong(), this.serverVersion);
        this.command = this.readString();
        this.mode = CommandBlockMode.getById(this.readVarInt());
        this.flags = this.readUnsignedByte();
        this.doesTrackOutput = (this.flags & 1) != 0;
        this.conditional = (this.flags & 2) != 0;
        this.automatic = (this.flags & 4) != 0;
    }

    @Override
    public void write() {
        this.writeLong(this.position.getSerializedPosition(this.serverVersion));
        this.writeString(this.command);
        this.writeVarInt(this.mode.ordinal());
        if (this.doesTrackOutput) {
            this.flags = (short)(this.flags | 1);
        }
        if (this.conditional) {
            this.flags = (short)(this.flags | 2);
        }
        if (this.automatic) {
            this.flags = (short)(this.flags | 4);
        }
        this.writeByte(this.flags);
    }

    @Override
    public void copy(WrapperPlayClientUpdateCommandBlock wrapper) {
        this.position = wrapper.position;
        this.command = wrapper.command;
        this.mode = wrapper.mode;
        this.doesTrackOutput = wrapper.doesTrackOutput;
        this.conditional = wrapper.conditional;
        this.automatic = wrapper.automatic;
        this.flags = wrapper.flags;
    }

    public Vector3i getPosition() {
        return this.position;
    }

    public void setPosition(Vector3i position) {
        this.position = position;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public CommandBlockMode getMode() {
        return this.mode;
    }

    public void setMode(CommandBlockMode mode) {
        this.mode = mode;
    }

    public boolean isDoesTrackOutput() {
        return this.doesTrackOutput;
    }

    public void setDoesTrackOutput(boolean doesTrackOutput) {
        this.doesTrackOutput = doesTrackOutput;
    }

    public boolean isConditional() {
        return this.conditional;
    }

    public void setConditional(boolean conditional) {
        this.conditional = conditional;
    }

    public boolean isAutomatic() {
        return this.automatic;
    }

    public void setAutomatic(boolean automatic) {
        this.automatic = automatic;
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public static enum CommandBlockMode {
        SEQUENCE,
        AUTO,
        REDSTONE;

        private static final CommandBlockMode[] VALUES;

        public static CommandBlockMode getById(int id) {
            return VALUES[id];
        }

        static {
            VALUES = CommandBlockMode.values();
        }
    }
}

