/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.libs.com.packetevents.wrapper.play.server;

import me.chrommob.baritoneremover.libs.com.packetevents.event.PacketSendEvent;
import me.chrommob.baritoneremover.libs.com.packetevents.manager.server.ServerVersion;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.packettype.PacketType;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.world.states.WrappedBlockState;
import me.chrommob.baritoneremover.libs.com.packetevents.util.Vector3i;
import me.chrommob.baritoneremover.libs.com.packetevents.wrapper.PacketWrapper;

public class WrapperPlayServerBlockChange
extends PacketWrapper<WrapperPlayServerBlockChange> {
    private Vector3i blockPosition;
    private int blockID;

    public WrapperPlayServerBlockChange(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerBlockChange(Vector3i blockPosition, int blockID) {
        super(PacketType.Play.Server.BLOCK_CHANGE);
        this.blockPosition = blockPosition;
        this.blockID = blockID;
    }

    @Override
    public void read() {
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
            this.blockPosition = new Vector3i(this.readInt(), this.readUnsignedByte(), this.readInt());
            int block = this.readVarInt();
            short blockData = this.readUnsignedByte();
            this.blockID = block | blockData << 12;
        } else {
            this.blockPosition = this.readBlockPosition();
            this.blockID = this.readVarInt();
        }
    }

    @Override
    public void write() {
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
            this.writeInt(this.blockPosition.getX());
            this.writeByte(this.blockPosition.getY());
            this.writeInt(this.blockPosition.getZ());
            this.writeVarInt(this.blockID & 0xFF);
            this.writeByte(this.blockID >> 12);
        } else {
            this.writeBlockPosition(this.blockPosition);
            this.writeVarInt(this.blockID);
        }
    }

    @Override
    public void copy(WrapperPlayServerBlockChange wrapper) {
        this.blockPosition = wrapper.blockPosition;
        this.blockID = wrapper.blockID;
    }

    public Vector3i getBlockPosition() {
        return this.blockPosition;
    }

    public void setBlockPosition(Vector3i blockPosition) {
        this.blockPosition = blockPosition;
    }

    public int getBlockId() {
        return this.blockID;
    }

    public void setBlockID(int blockID) {
        this.blockID = blockID;
    }

    public WrappedBlockState getBlockState() {
        return WrappedBlockState.getByGlobalId(this.serverVersion.toClientVersion(), this.blockID);
    }

    public void setBlockState(WrappedBlockState blockState) {
        this.blockID = blockState.getGlobalId();
    }
}

