/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.libs.com.packetevents.wrapper.play.server;

import me.chrommob.baritoneremover.libs.com.packetevents.event.PacketSendEvent;
import me.chrommob.baritoneremover.libs.com.packetevents.manager.server.ServerVersion;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.packettype.PacketType;
import me.chrommob.baritoneremover.libs.com.packetevents.wrapper.PacketWrapper;

public class WrapperPlayServerEntityRelativeMoveAndRotation
extends PacketWrapper<WrapperPlayServerEntityRelativeMoveAndRotation> {
    private static final float ROTATION_FACTOR = 0.7111111f;
    private static final double MODERN_DELTA_DIVISOR = 4096.0;
    private static final double LEGACY_DELTA_DIVISOR = 32.0;
    private int entityID;
    private double deltaX;
    private double deltaY;
    private double deltaZ;
    private float yaw;
    private float pitch;
    private boolean onGround;

    public WrapperPlayServerEntityRelativeMoveAndRotation(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerEntityRelativeMoveAndRotation(int entityID, double deltaX, double deltaY, double deltaZ, float yaw, float pitch, boolean onGround) {
        super(PacketType.Play.Server.ENTITY_RELATIVE_MOVE_AND_ROTATION);
        this.entityID = entityID;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.deltaZ = deltaZ;
        this.yaw = yaw;
        this.pitch = pitch;
        this.onGround = onGround;
    }

    @Override
    public void read() {
        this.entityID = this.readVarInt();
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
            this.deltaX = (double)this.readShort() / 4096.0;
            this.deltaY = (double)this.readShort() / 4096.0;
            this.deltaZ = (double)this.readShort() / 4096.0;
        } else {
            this.deltaX = (double)this.readByte() / 32.0;
            this.deltaY = (double)this.readByte() / 32.0;
            this.deltaZ = (double)this.readByte() / 32.0;
        }
        this.yaw = (float)this.readByte() / 0.7111111f;
        this.pitch = (float)this.readByte() / 0.7111111f;
        this.onGround = this.readBoolean();
    }

    @Override
    public void write() {
        this.writeVarInt(this.entityID);
        if (this.serverVersion.isNewerThanOrEquals(ServerVersion.V_1_9)) {
            this.writeShort((short)(this.deltaX * 4096.0));
            this.writeShort((short)(this.deltaY * 4096.0));
            this.writeShort((short)(this.deltaZ * 4096.0));
        } else {
            this.writeByte((byte)(this.deltaX * 32.0));
            this.writeByte((byte)(this.deltaY * 32.0));
            this.writeByte((byte)(this.deltaZ * 32.0));
        }
        this.writeByte((int)(this.yaw * 0.7111111f));
        this.writeByte((int)(this.pitch * 0.7111111f));
        this.writeBoolean(this.onGround);
    }

    @Override
    public void copy(WrapperPlayServerEntityRelativeMoveAndRotation wrapper) {
        this.entityID = wrapper.entityID;
        this.deltaX = wrapper.deltaX;
        this.deltaY = wrapper.deltaY;
        this.deltaZ = wrapper.deltaZ;
        this.yaw = wrapper.yaw;
        this.pitch = wrapper.pitch;
        this.onGround = wrapper.onGround;
    }

    public int getEntityId() {
        return this.entityID;
    }

    public void setEntityId(int entityID) {
        this.entityID = entityID;
    }

    public double getDeltaX() {
        return this.deltaX;
    }

    public void setDeltaX(double deltaX) {
        this.deltaX = deltaX;
    }

    public double getDeltaY() {
        return this.deltaY;
    }

    public void setDeltaY(double deltaY) {
        this.deltaY = deltaY;
    }

    public double getDeltaZ() {
        return this.deltaZ;
    }

    public void setDeltaZ(double deltaZ) {
        this.deltaZ = deltaZ;
    }

    public float getYaw() {
        return this.yaw;
    }

    public void setYaw(float yaw) {
        this.yaw = yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float pitch) {
        this.pitch = pitch;
    }

    public boolean isOnGround() {
        return this.onGround;
    }

    public void setOnGround(boolean onGround) {
        this.onGround = onGround;
    }
}

