/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.libs.com.packetevents.wrapper.play.server;

import me.chrommob.baritoneremover.libs.com.packetevents.event.PacketSendEvent;
import me.chrommob.baritoneremover.libs.com.packetevents.manager.server.ServerVersion;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.packettype.PacketType;
import me.chrommob.baritoneremover.libs.com.packetevents.util.Vector3d;
import me.chrommob.baritoneremover.libs.com.packetevents.wrapper.PacketWrapper;

public class WrapperPlayServerEntityVelocity
extends PacketWrapper<WrapperPlayServerEntityVelocity> {
    private static final double PRECISION_LOSS_FIX = 1.0E-11;
    private int entityID;
    private Vector3d velocity;

    public WrapperPlayServerEntityVelocity(PacketSendEvent event) {
        super(event);
    }

    public WrapperPlayServerEntityVelocity(int entityID, Vector3d velocity) {
        super(PacketType.Play.Server.ENTITY_VELOCITY);
        this.entityID = entityID;
        this.velocity = velocity;
    }

    @Override
    public void read() {
        this.entityID = this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10) ? this.readInt() : this.readVarInt();
        double velX = (double)this.readShort() / 8000.0;
        double velY = (double)this.readShort() / 8000.0;
        double velZ = (double)this.readShort() / 8000.0;
        this.velocity = new Vector3d(velX, velY, velZ);
    }

    @Override
    public void write() {
        if (this.serverVersion.isOlderThanOrEquals(ServerVersion.V_1_7_10)) {
            this.writeInt(this.entityID);
        } else {
            this.writeVarInt(this.entityID);
        }
        this.writeShort((int)(this.velocity.x * 8000.0 + Math.copySign(1.0E-11, this.velocity.x)));
        this.writeShort((int)(this.velocity.y * 8000.0 + Math.copySign(1.0E-11, this.velocity.y)));
        this.writeShort((int)(this.velocity.z * 8000.0 + Math.copySign(1.0E-11, this.velocity.z)));
    }

    @Override
    public void copy(WrapperPlayServerEntityVelocity wrapper) {
        this.entityID = wrapper.entityID;
        this.velocity = wrapper.velocity;
    }

    public int getEntityId() {
        return this.entityID;
    }

    public void setEntityId(int entityID) {
        this.entityID = entityID;
    }

    public Vector3d getVelocity() {
        return this.velocity;
    }

    public void setVelocity(Vector3d velocity) {
        this.velocity = velocity;
    }
}

