/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.libs.io.packetevents;

import me.chrommob.baritoneremover.libs.com.packetevents.PacketEvents;
import me.chrommob.baritoneremover.libs.com.packetevents.event.PacketListenerPriority;
import me.chrommob.baritoneremover.libs.com.packetevents.event.SimplePacketListenerAbstract;
import me.chrommob.baritoneremover.libs.com.packetevents.event.UserConnectEvent;
import me.chrommob.baritoneremover.libs.com.packetevents.event.UserDisconnectEvent;
import me.chrommob.baritoneremover.libs.com.packetevents.event.UserLoginEvent;
import me.chrommob.baritoneremover.libs.com.packetevents.event.simple.PacketConfigReceiveEvent;
import me.chrommob.baritoneremover.libs.com.packetevents.event.simple.PacketConfigSendEvent;
import me.chrommob.baritoneremover.libs.com.packetevents.event.simple.PacketLoginSendEvent;
import me.chrommob.baritoneremover.libs.com.packetevents.event.simple.PacketPlayReceiveEvent;
import me.chrommob.baritoneremover.libs.com.packetevents.event.simple.PacketPlaySendEvent;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.packettype.PacketType;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.world.states.type.StateTypes;
import me.chrommob.baritoneremover.libs.com.packetevents.util.TimeStampMode;
import me.chrommob.baritoneremover.libs.com.packetevents.wrapper.play.client.WrapperPlayClientInteractEntity;
import me.chrommob.baritoneremover.libs.com.packetevents.wrapper.play.server.WrapperPlayServerBlockChange;
import me.chrommob.baritoneremover.libs.com.packetevents.wrapper.play.server.WrapperPlayServerSystemChatMessage;
import me.chrommob.baritoneremover.libs.io.packetevents.factory.spigot.SpigotPacketEventsBuilder;
import me.chrommob.baritoneremover.libs.io.packetevents.util.SpigotConversionUtil;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class PacketEventsPlugin
extends JavaPlugin {
    public void onLoad() {
        PacketEvents.setAPI(SpigotPacketEventsBuilder.build((Plugin)this));
        PacketEvents.getAPI().load();
    }

    public void onEnable() {
        PacketEvents.getAPI().getSettings().debug(false).checkForUpdates(true).timeStampMode(TimeStampMode.MILLIS).reEncodeByDefault(true);
        PacketEvents.getAPI().init();
        SimplePacketListenerAbstract listener = new SimplePacketListenerAbstract(PacketListenerPriority.HIGH){

            @Override
            public void onPacketLoginSend(PacketLoginSendEvent event) {
            }

            @Override
            public void onPacketConfigReceive(PacketConfigReceiveEvent event) {
            }

            @Override
            public void onPacketConfigSend(PacketConfigSendEvent event) {
            }

            @Override
            public void onPacketPlayReceive(PacketPlayReceiveEvent event) {
                WrapperPlayClientInteractEntity interaction;
                if (event.getPacketType() == PacketType.Play.Client.INTERACT_ENTITY && (interaction = new WrapperPlayClientInteractEntity(event)).getAction() == WrapperPlayClientInteractEntity.InteractAction.ATTACK) {
                    Player player = (Player)event.getPlayer();
                    WrapperPlayServerBlockChange blockChange = new WrapperPlayServerBlockChange(SpigotConversionUtil.fromBukkitLocation(player.getLocation()).getPosition().toVector3i().subtract(0, 1, 0), StateTypes.COAL_BLOCK.createBlockState().getGlobalId());
                    event.getUser().sendPacket(blockChange);
                }
            }

            @Override
            public void onPacketPlaySend(PacketPlaySendEvent event) {
                if (event.getPacketType() == PacketType.Play.Server.BLOCK_CHANGE) {
                    WrapperPlayServerBlockChange bc = new WrapperPlayServerBlockChange(event);
                    ((Player)event.getPlayer()).sendMessage("Type: " + bc.getBlockState().getType().getName());
                } else if (event.getPacketType() == PacketType.Play.Server.SYSTEM_CHAT_MESSAGE) {
                    WrapperPlayServerSystemChatMessage wrapperPlayServerSystemChatMessage = new WrapperPlayServerSystemChatMessage(event);
                }
            }

            @Override
            public void onUserConnect(UserConnectEvent event) {
                PacketEvents.getAPI().getLogManager().debug("User: (host-name) " + event.getUser().getAddress().getHostString() + " connected...");
            }

            @Override
            public void onUserLogin(UserLoginEvent event) {
                PacketEvents.getAPI().getLogManager().debug("You logged in! User name: " + event.getUser().getProfile().getName());
            }

            @Override
            public void onUserDisconnect(UserDisconnectEvent event) {
                PacketEvents.getAPI().getLogManager().debug("User: (host-name) " + event.getUser().getAddress().getHostString() + " disconnected...");
            }
        };
    }

    public void onDisable() {
        PacketEvents.getAPI().terminate();
    }
}

