/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.libs.kyori.adventure.text.minimessage.translation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import me.chrommob.baritoneremover.libs.kyori.adventure.pointer.Pointered;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.Component;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.TranslatableComponent;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.TranslationArgument;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.TranslationArgumentLike;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.VirtualComponent;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.VirtualComponentRenderer;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.format.Style;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.minimessage.MiniMessage;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.minimessage.tag.Tag;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.minimessage.translation.ArgumentTag;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.minimessage.translation.LocalePointered;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.minimessage.translation.MiniMessageTranslatorArgument;
import me.chrommob.baritoneremover.libs.kyori.adventure.text.minimessage.translation.MiniMessageTranslatorTarget;
import me.chrommob.baritoneremover.libs.kyori.adventure.translation.Translator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MiniMessageTranslator
implements Translator {
    private final MiniMessage miniMessage;

    public MiniMessageTranslator() {
        this(MiniMessage.miniMessage());
    }

    public MiniMessageTranslator(@NotNull MiniMessage miniMessage) {
        this.miniMessage = Objects.requireNonNull(miniMessage, "miniMessage");
    }

    @Nullable
    protected abstract String getMiniMessageString(@NotNull String var1, @NotNull Locale var2);

    @Override
    @Nullable
    public final MessageFormat translate(@NotNull String key, @NotNull Locale locale) {
        return null;
    }

    @Override
    @Nullable
    public final Component translate(@NotNull TranslatableComponent component, @NotNull Locale locale) {
        Component resultingComponent;
        String miniMessageString = this.getMiniMessageString(component.key(), locale);
        if (miniMessageString == null) {
            return null;
        }
        Pointered target = new LocalePointered(locale);
        List<TranslationArgument> translationArguments = component.arguments();
        if (translationArguments.isEmpty()) {
            resultingComponent = this.miniMessage.deserialize(miniMessageString, target);
        } else {
            TagResolver.Builder tagResolverBuilder = TagResolver.builder();
            ArrayList<Tag> indexedArguments = new ArrayList<Tag>(translationArguments.size());
            boolean targetAlreadyOverridden = false;
            for (TranslationArgument argument : translationArguments) {
                Object value = argument.value();
                if (value instanceof VirtualComponent) {
                    VirtualComponentRenderer<?> renderer = ((VirtualComponent)value).renderer();
                    if (renderer instanceof MiniMessageTranslatorTarget) {
                        if (targetAlreadyOverridden) {
                            throw new IllegalArgumentException("Multiple Argument.target() translation arguments have been set!");
                        }
                        target = ((MiniMessageTranslatorTarget)renderer).pointered();
                        targetAlreadyOverridden = true;
                        continue;
                    }
                    if (renderer instanceof MiniMessageTranslatorArgument) {
                        Tag tag;
                        MiniMessageTranslatorArgument translatorArgument = (MiniMessageTranslatorArgument)renderer;
                        Object data = translatorArgument.data();
                        if (data instanceof TranslationArgumentLike) {
                            tag = Tag.selfClosingInserting((TranslationArgumentLike)data);
                            tagResolverBuilder.tag(translatorArgument.name(), tag);
                            indexedArguments.add(tag);
                            continue;
                        }
                        if (data instanceof Tag) {
                            tag = (Tag)data;
                            tagResolverBuilder.tag(translatorArgument.name(), tag);
                            indexedArguments.add(tag);
                            continue;
                        }
                        if (data instanceof TagResolver) {
                            tagResolverBuilder.resolvers((TagResolver)data);
                        } else {
                            throw new IllegalArgumentException("Unknown translator argument type: " + data.getClass());
                        }
                    }
                }
                indexedArguments.add(Tag.selfClosingInserting(argument));
            }
            resultingComponent = this.miniMessage.deserialize(miniMessageString, target, (TagResolver)new ArgumentTag(indexedArguments, tagResolverBuilder.build()));
        }
        Style style = component.style();
        if (!style.isEmpty()) {
            resultingComponent = resultingComponent.applyFallbackStyle(style);
        }
        return resultingComponent.append(component.children());
    }
}

