/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.listener;

import me.chrommob.baritoneremover.BaritoneRemover;
import me.chrommob.baritoneremover.data.DataHolder;
import me.chrommob.baritoneremover.data.PlayerData;
import me.chrommob.baritoneremover.libs.com.packetevents.event.SimplePacketListenerAbstract;
import me.chrommob.baritoneremover.libs.com.packetevents.event.simple.PacketPlayReceiveEvent;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.packettype.PacketType;
import me.chrommob.baritoneremover.libs.com.packetevents.protocol.player.DiggingAction;
import me.chrommob.baritoneremover.libs.com.packetevents.wrapper.play.client.WrapperPlayClientPlayerDigging;

public class MiningListener
extends SimplePacketListenerAbstract {
    private final DataHolder dataHolder;

    public MiningListener(BaritoneRemover pl) {
        this.dataHolder = pl.dataHolder();
    }

    @Override
    public void onPacketPlayReceive(PacketPlayReceiveEvent event) {
        if (!event.getPacketType().equals(PacketType.Play.Client.PLAYER_DIGGING)) {
            return;
        }
        WrapperPlayClientPlayerDigging packet = new WrapperPlayClientPlayerDigging(event);
        if (packet.getBlockFace() == null) {
            return;
        }
        if (packet.getAction() != DiggingAction.START_DIGGING && packet.getAction() != DiggingAction.FINISHED_DIGGING) {
            return;
        }
        PlayerData pd = this.dataHolder.getPlayerData(event.getUser().getName());
        if (pd == null) {
            return;
        }
        if (packet.getAction() == DiggingAction.START_DIGGING) {
            pd.startMining();
            return;
        }
        if (packet.getAction() == DiggingAction.FINISHED_DIGGING) {
            pd.finishMining();
        }
    }
}

