/*
 * Decompiled with CFR 0.152.
 */
package me.chrommob.baritoneremover.webhook;

import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import me.chrommob.baritoneremover.BaritoneRemover;
import me.chrommob.baritoneremover.config.ConfigManager;
import me.chrommob.baritoneremover.webhook.WebHookMessage;
import org.bukkit.Bukkit;

public class Sender {
    private final ConfigManager configManager;
    private String url;
    private boolean enabled;
    private int taskID = -1;
    private int remaining = -1;
    private long remainingReset = 0L;
    private final List<WebHookMessage> priorityMessages = new ArrayList<WebHookMessage>();
    private final List<WebHookMessage> messages = new ArrayList<WebHookMessage>();
    private final Map<String, Long> playerLastMessage = new HashMap<String, Long>();

    public Sender(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public void load() {
        this.url = this.configManager.webHookUrl();
        this.enabled = this.configManager.webHookEnabled();
        if (this.enabled) {
            Bukkit.getScheduler().cancelTask(this.taskID);
            this.taskID = BaritoneRemover.scheduler().runTimer(this::sendMessages, 20L, 20L);
        } else {
            Bukkit.getScheduler().cancelTask(this.taskID);
        }
    }

    public void add(String message, String username, boolean priority) {
        if (!this.enabled) {
            return;
        }
        if (priority) {
            this.priorityMessages.add(new WebHookMessage(message, username));
        } else {
            this.messages.add(new WebHookMessage(message, username));
        }
    }

    private void send(WebHookMessage message) {
        this.playerLastMessage.put(message.username, System.currentTimeMillis());
        try {
            HttpsURLConnection connection = (HttpsURLConnection)new URL(this.url).openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Accept", "application/json, text/plain, */*");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0");
            connection.setDoInput(true);
            connection.setDoOutput(true);
            connection.getOutputStream().write(message.content.getBytes());
            connection.getOutputStream().flush();
            connection.getOutputStream().close();
            connection.getInputStream().close();
            connection.disconnect();
            Map<String, List<String>> map = connection.getHeaderFields();
            this.remaining = map.containsKey("X-RateLimit-Remaining") ? Integer.parseInt(map.get("X-RateLimit-Remaining").get(0)) : -1;
            this.remainingReset = map.containsKey("X-RateLimit-Reset") ? Long.parseLong(map.get("X-RateLimit-Reset").get(0)) * 1000L : System.currentTimeMillis();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendMessages() {
        ArrayList<WebHookMessage> priorityMessages = new ArrayList<WebHookMessage>(this.priorityMessages);
        ArrayList<WebHookMessage> toSend = new ArrayList<WebHookMessage>(priorityMessages);
        this.priorityMessages.removeAll(priorityMessages);
        ArrayList<WebHookMessage> messages = new ArrayList<WebHookMessage>(this.messages);
        for (WebHookMessage message : messages) {
            if (this.playerLastMessage.containsKey(message.username)) continue;
            toSend.add(message);
            this.messages.remove(message);
        }
        messages = new ArrayList<WebHookMessage>(this.messages);
        messages.sort(Comparator.comparingLong(o -> this.playerLastMessage.get(o.username)));
        toSend.addAll(messages);
        this.messages.removeAll(messages);
        for (WebHookMessage message : toSend) {
            if (this.remaining == 0 && this.remainingReset > System.currentTimeMillis()) continue;
            this.send(message);
        }
    }
}

