/*
 * Decompiled with CFR 0.152.
 */
package chargedcharms.client.integration;

import chargedcharms.common.TagManager;
import chargedcharms.common.item.ChargedCharmsItems;
import chargedcharms.config.ConfigHandler;
import chargedcharms.util.IngredientHelper;
import chargedcharms.util.RegistryHelper;
import chargedcharms.util.ResourceLocationHelper;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_4174;
import net.minecraft.class_5321;
import net.minecraft.class_7710;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9334;
import technology.roughness.whitenoise.platform.Services;

public class CharmChargingRecipeMaker {
    public static List<Pair<class_1799, class_8786<class_3955>>> createRecipes(String plugin) {
        String group = plugin + ".charm.charging";
        ArrayList<Pair<class_1799, class_8786<class_3955>>> recipes = new ArrayList<Pair<class_1799, class_8786<class_3955>>>();
        ArrayList regenFoods = Lists.newArrayList();
        ArrayList absorptionFoods = Lists.newArrayList();
        RegistryHelper.getRegistry(class_7924.field_41197).method_10220().filter(item -> {
            class_1799 stack = new class_1799((class_1935)item);
            return stack.method_57826(class_9334.field_50075);
        }).forEach(food -> {
            class_1799 foodStack = new class_1799((class_1935)food);
            class_4174 foodProperties = (class_4174)foodStack.method_58694(class_9334.field_50075);
            if (!foodStack.method_31573(TagManager.Items.CHARM_FOODS_BLACKLIST) && foodProperties != null) {
                if (foodProperties.comp_2491() > 4) {
                    absorptionFoods.add(foodStack.method_7909());
                }
                regenFoods.add(foodStack.method_7909());
            }
        });
        if (!ConfigHandler.Common.disableRegenCharm()) {
            recipes.add(Pair.of((Object)new class_1799((class_1935)ChargedCharmsItems.regenerationCharm), CharmChargingRecipeMaker.getRecipe(group, ".regen", ChargedCharmsItems.regenerationCharm, class_1856.method_26964(regenFoods.stream()))));
        }
        if (!ConfigHandler.Common.disableAbsorptionCharm()) {
            recipes.add((Pair<class_1799, class_8786<class_3955>>)Pair.of((Object)new class_1799((class_1935)ChargedCharmsItems.absorptionCharm), CharmChargingRecipeMaker.getRecipe(group, ".absorption", ChargedCharmsItems.absorptionCharm, class_1856.method_26964(absorptionFoods.stream()))));
        }
        if (!ConfigHandler.Common.disableTotemCharm()) {
            recipes.add((Pair<class_1799, class_8786<class_3955>>)Pair.of((Object)new class_1799((class_1935)ChargedCharmsItems.totemCharm), CharmChargingRecipeMaker.getRecipe(group, ".totem", ChargedCharmsItems.totemCharm, class_1856.method_8101((class_1935)class_1802.field_8288))));
        }
        if (Services.PLATFORM.isModLoaded("biomemakeover") && !ConfigHandler.Common.disableEnchTotemCharm()) {
            recipes.add((Pair<class_1799, class_8786<class_3955>>)Pair.of((Object)new class_1799((class_1935)ChargedCharmsItems.enchantedTotemCharm), CharmChargingRecipeMaker.getRecipe(group, ".enchanted_totem", ChargedCharmsItems.enchantedTotemCharm, IngredientHelper.fromTag(TagManager.Items.ENCHANTED_TOTEMS))));
        }
        if (!ConfigHandler.Common.disableSpeedCharm()) {
            recipes.add((Pair<class_1799, class_8786<class_3955>>)Pair.of((Object)new class_1799((class_1935)ChargedCharmsItems.speedCharm), CharmChargingRecipeMaker.getRecipe(group, ".speed", ChargedCharmsItems.speedCharm, class_1856.method_8101((class_1935)class_1802.field_8479))));
        }
        if (!ConfigHandler.Common.disableWaterBreathingCharm()) {
            recipes.add((Pair<class_1799, class_8786<class_3955>>)Pair.of((Object)new class_1799((class_1935)ChargedCharmsItems.waterBreathingCharm), CharmChargingRecipeMaker.getRecipe(group, ".water_breathing", ChargedCharmsItems.waterBreathingCharm, class_1856.method_8101((class_1935)class_1802.field_17532))));
        }
        return recipes;
    }

    private static class_8786<class_3955> getRecipe(String group, String label, class_1792 charm, class_1856 chargeItems) {
        class_1799 unchargedCharm = new class_1799((class_1935)charm);
        unchargedCharm.method_7974(unchargedCharm.method_7936());
        class_1856 baseCharm = class_1856.method_8101((class_1935)unchargedCharm.method_7909());
        class_1799 chargedCharm = unchargedCharm.method_7972();
        chargedCharm.method_7974(chargedCharm.method_7936() - 1);
        class_2371 chargedCharmInputs = class_2371.method_10212(null, (Object[])new class_1856[]{baseCharm, chargeItems});
        return new class_8786(class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)ResourceLocationHelper.prefix(group + label)), (class_1860)new class_1867(group, class_7710.field_40251, chargedCharm, (List)chargedCharmInputs));
    }
}

